/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.picture;

import android.os.RemoteException;
import android.util.Log;
import com.hisense.hotel.HisenseManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.IPictureListener;

public class PictureHelper {
    private static final String TAG = "XBH-SDK-" + PictureHelper.class.getSimpleName();
    public static final int COLOR_TEMP_COLD = 0;
    public static final int COLOR_TEMP_COLDISH = 1;
    public static final int COLOR_TEMP_STANDARD = 2;
    public static final int COLOR_TEMP_WARMISH = 3;
    public static final int COLOR_TEMP_WARM = 4;
    public static final int CUS_PICTURE_MODE_STANDARD = 0;
    public static final int CUS_PICTURE_MODE_SOFT = 1;
    public static final int CUS_PICTURE_MODE_COLORFUL = 2;
    public static final int CUS_PICTURE_MODE_MOVIE = 3;
    public static final int CUS_PICTURE_MODE_USER = 5;
    public static final int MTK_PICTURE_MODE_STANDARD = 7;
    public static final int MTK_PICTURE_MODE_SOFT = 2;
    public static final int MTK_PICTURE_MODE_COLORFUL = 3;
    public static final int MTK_PICTURE_MODE_MOVIE = 9;
    public static final int MTK_PICTURE_MODE_USER = 0;
    public static final int CUS_ASPECT_MODE_FULL = 0;
    public static final int CUS_ASPECT_MODE_STANDARD = 1;
    public static final int CUS_ASPECT_MODE_SCALE1 = 2;
    public static final int CUS_ASPECT_MODE_SCALE2 = 3;
    public static final int CUS_ASPECT_MODE_P2P = 4;
    public static final int PUBLIC_ASPECT_MODE_STANDARD = 0;
    public static final int PUBLIC_ASPECT_MODE_FULL = 4;
    public static final int PUBLIC_ASPECT_MODE_16_9 = 1;
    public static final int PUBLIC_ASPECT_MODE_14_9 = 5;
    public static final int PUBLIC_ASPECT_MODE_P2P = 3;
    public static final int PUBLIC_ASPECT_MODE_4_3 = 2;
    public static final int PUBLIC_ASPECT_MODE_SUPER_ZOOM = 6;
    public static final int PUBLIC_COLOR_RANGE_AUTO = 0;
    public static final int PUBLIC_COLOR_RANGE_FULL = 1;
    public static final int PUBLIC_COLOR_RANGE_LIMIT = 2;
    public static final int CUS_COLOR_RANGE_AUTO = 0;
    public static final int CUS_COLOR_RANGE_FULL = 2;
    public static final int CUS_COLOR_RANGE_LIMIT = 1;
    public static final int GAMMA_1_8 = 0;
    public static final int GAMMA_2_0 = 1;
    public static final int GAMMA_2_2 = 2;
    public static final int GAMMA_2_4 = 3;
    public static final int GAMMA_1_8_8_6 = 4;
    public static final String DEFALULT_HUES = "persist.xbh.defalut_hues";
    public static final String DEFALULT_STAS = "persist.xbh.defalut_sats";
    public static final String DEFALULT_BRIS = "persist.xbh.defalut_bris";
    public static final int LOCAL_DIMMING_OFF = 0;
    public static final int LOCAL_DIMMING_LOW = 1;
    public static final int LOCAL_DIMMING_MID = 2;
    public static final int LOCAL_DIMMING_HIGH = 3;
    public static final int LOCAL_DIMMING_CUSTOM_TOP_OFF = 0;
    public static final int LOCAL_DIMMING_CUSTOM_TOP_WHITE = 1;
    public static final int LOCAL_DIMMING_CUSTOM_TOP_BLACK = 2;
    public static int[] MULTI_SOURCE_LIST = null;

    public PictureHelper() {
        if (MULTI_SOURCE_LIST == null) {
            MULTI_SOURCE_LIST = this.getSystemProperties("ro.product.board.type", "XMM966BF").equals("XMM966BG") ? new int[]{11, 21} : new int[]{10, 17, 21};
        }
    }

    public boolean registerPictureListener(IPictureListener listener) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().registerPictureListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterPictureListener(IPictureListener listener) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().unRegisterPictureListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBacklightEnable(boolean value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setBacklightEnable(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getBacklightEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getBacklightEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBacklightMode() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getBacklightMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setBacklightMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setBacklightMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBacklight(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setBacklight(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBacklight_nosave(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setBacklight_nosave(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBacklight_nosave() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getBacklight_nosave();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getAvgLuma() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getAvgPixelLuma();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getBacklight() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getBacklight();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setContrast(int value) {
        try {
            if (value <= 0) {
                value = 0;
            } else if (value >= 100) {
                value = 100;
            }
            return XbhAidlApi.getInstance().getPicInterface().setContrast(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getContrast() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getContrast();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setBrightness(int value) {
        try {
            if (value <= 0) {
                value = 0;
            } else if (value >= 100) {
                value = 100;
            }
            return XbhAidlApi.getInstance().getPicInterface().setBrightness(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBrightness() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getBrightness();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSharpness(int value) {
        try {
            if ((value *= 5) <= 0) {
                value = 0;
            } else if (value >= 100) {
                value = 100;
            }
            return XbhAidlApi.getInstance().getPicInterface().setSharpness(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSharpness() {
        try {
            int value = XbhAidlApi.getInstance().getPicInterface().getSharpness();
            return value /= 5;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setHue(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setHue(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getHue() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getHue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSaturation(int value) {
        try {
            if (value <= 0) {
                value = 0;
            } else if (value >= 100) {
                value = 100;
            }
            return XbhAidlApi.getInstance().getPicInterface().setSaturation(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSaturation() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getSaturation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setColorTempMode(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setColorTempMode(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getColorTempMode() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getColorTempMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setAspectMode(int value) {
        try {
            switch (value) {
                case 0: {
                    value = 4;
                    break;
                }
                case 1: {
                    value = 2;
                    break;
                }
                case 2: {
                    value = 5;
                    break;
                }
                case 3: {
                    value = 6;
                    break;
                }
                case 4: {
                    value = 3;
                    break;
                }
            }
            return XbhAidlApi.getInstance().getPicInterface().setAspectMode(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAspectMode() {
        try {
            int value = XbhAidlApi.getInstance().getPicInterface().getAspectMode();
            switch (value) {
                case 4: {
                    value = 0;
                    break;
                }
                case 2: {
                    value = 1;
                    break;
                }
                case 5: {
                    value = 2;
                    break;
                }
                case 6: {
                    value = 3;
                    break;
                }
                case 3: {
                    value = 4;
                    break;
                }
            }
            return value;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setPictureMode(int value) {
        try {
            boolean ret = false;
            ret = XbhAidlApi.getInstance().getPicInterface().setPictureMode(value);
            return ret;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCustomPictureMode(int value) {
        try {
            return HisenseManager.getInstance().setCustomPictureMode(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPictureMode() {
        int value = 0;
        try {
            value = XbhAidlApi.getInstance().getPicInterface().getPictureMode();
            return value;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return value;
        }
    }

    public int getCustomPictureMode() {
        try {
            return HisenseManager.getInstance().getCustomPictureMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getNR() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getNR();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setNR(int mode) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setNR(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPCMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCMode() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean enableDisplayOffset(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().enableDisplayOffset(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEyeComfortEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setEyeComfortEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getEyeComfortEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getEyeComfortEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setGraphicBrightness(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setGraphicBrightness(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getGraphicBrightness() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getGraphicBrightness();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setGraphicContrast(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setGraphicContrast(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getGraphicContrast() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getGraphicContrast();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setGraphicSaturation(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setGraphicSaturation(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getGraphicSaturation() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getGraphicSaturation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setGraphicColorTempMode(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setGraphicColorTempMode(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getGraphicColorTempMode() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getGraphicColorTempMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setGamma(int group) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setGamma(group);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getGamma() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getGamma();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setColorTempPara(int colorTempMode, int[] RGBValues) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setColorTempPara(colorTempMode, RGBValues);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getColorTempPara(int colorTempMode) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getColorTempPara(colorTempMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getEnergyStarEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getEnergyStarEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEnergyStarEnable(boolean value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setEnergyStarEnable(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDCREnable(boolean onoff) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setDCREnable(onoff);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getDCREnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getDCREnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setColorRange(int colorRange) {
        try {
            switch (colorRange) {
                case 0: {
                    colorRange = 0;
                    break;
                }
                case 1: {
                    colorRange = 2;
                    break;
                }
                case 2: {
                    colorRange = 1;
                    break;
                }
            }
            return XbhAidlApi.getInstance().getPicInterface().setColorRange(colorRange);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getColorRange() {
        try {
            int colorRange = XbhAidlApi.getInstance().getPicInterface().getColorRange();
            switch (colorRange) {
                case 0: {
                    colorRange = 0;
                    break;
                }
                case 2: {
                    colorRange = 1;
                    break;
                }
                case 1: {
                    colorRange = 2;
                    break;
                }
            }
            return colorRange;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean resetCustomPictureSettings() {
        try {
            HisenseManager.getInstance().resetCustomPictureSettings();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean resetPictureSettings() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().resetPictureSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPCBlueGain(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCBlueGain(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCBlueGain() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCBlueGain();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPCRedGain(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCRedGain(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCRedGain() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCRedGain();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPCGreenGain(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCGreenGain(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCGreenGain() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCGreenGain();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPCColorTunerEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCColorTunerEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getPCColorTunerEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCColorTunerEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPCRedTunerOffset(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCRedTunerOffset(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCRedTunerOffset() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCRedTunerOffset();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPCGreenTunerOffset(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCGreenTunerOffset(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCGreenTunerOffset() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCGreenTunerOffset();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPCBlueTunerOffset(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPCBlueTunerOffset(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPCBlueTunerOffset() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPCBlueTunerOffset();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setPixelShiftInterval(int type) {
        try {
            XbhAidlApi.getInstance().getPicInterface().setPixelShiftInterval(type);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getPixelShiftInterval() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPixelShiftInterval();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCustomColorTempModePara(int mode, int[] para) {
        try {
            Log.d((String)TAG, (String)("setCustomColorTempModePara: para=" + Arrays.toString(para)));
            return HisenseManager.getInstance().setCustomColorTempModePara(mode, para);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setUserColorTempModePara(int mode, int[] para) {
        try {
            return HisenseManager.getInstance().setUserColorTempModePara(mode, para);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getDefaultCustomColorTempModePara(int mode) {
        return HisenseManager.getInstance().getDefaultCustomColorTempModePara(mode);
    }

    public int[] getCustomColorTempModePara(int mode) {
        int[] para = this.getDefaultCustomColorTempModePara(mode);
        try {
            return HisenseManager.getInstance().getCustomColorTempModePara(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return para;
        }
    }

    public int[] getUserColorTempModePara(int mode) {
        int[] para = this.getDefaultCustomColorTempModePara(mode);
        try {
            return HisenseManager.getInstance().getUserColorTempModePara(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return para;
        }
    }

    public int getUserColorTempMode() {
        try {
            return HisenseManager.getInstance().getUserColorTempMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getCustomColorTempMode() {
        try {
            return HisenseManager.getInstance().getCustomColorTempMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCustomColorTempMode(int mode) {
        try {
            return HisenseManager.getInstance().setCustomColorTempMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCustomColorTempMode(int mode, boolean force) {
        try {
            return HisenseManager.getInstance().setCustomColorTempModeByForce(mode, force);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setUserColorTempMode(int mode) {
        try {
            return HisenseManager.getInstance().setUserColorTempMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setScreenRotarion(int rotation) {
        Log.d((String)TAG, (String)("setScreenRotarion: rotation=" + rotation));
        HisenseManager.getInstance().setScreenRotarion(rotation);
    }

    public int getScreenRotarion() {
        return HisenseManager.getInstance().getScreenRotarion();
    }

    public void setMenuRotarion(int rotation) {
        HisenseManager.getInstance().setMenuRotarion(rotation);
    }

    public int getMenuRotarion() {
        return HisenseManager.getInstance().getMenuRotarion();
    }

    public String getSystemProperties(String key, String defaultValue) {
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getMethod("get", String.class, String.class);
            String value = (String)method.invoke(classtype, key, defaultValue);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setVideoRotation(int rotation) {
        HisenseManager.getInstance().setVideoRotation(rotation);
    }

    public int getVideoRotation() {
        return HisenseManager.getInstance().getVideoRotation();
    }

    public void setSystemProperties(String key, String value) {
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getMethod("set", String.class, String.class);
            method.invoke(classtype, key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setTilingHorMonitorNum(int num) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingHorMonitorNum(num);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingHorMonitorNum() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingHorMonitorNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setTilingVerMonitorNum(int num) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingVerMonitorNum(num);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingVerMonitorNum() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingVerMonitorNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setTilingCurPos(int position) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingCurPos(position);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingCurPos() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingCurPos();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setTilingFrameCompTop(int top) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingFrameCompTop(top);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingFrameCompTop() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingFrameCompTop();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 15;
        }
    }

    public boolean setTilingFrameCompBottom(int bottom) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingFrameCompBottom(bottom);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingFrameCompBottom() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingFrameCompBottom();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 15;
        }
    }

    public boolean setTilingFrameCompLeft(int left) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingFrameCompLeft(left);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingFrameCompLeft() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingFrameCompLeft();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 15;
        }
    }

    public boolean setTilingFrameCompRight(int right) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingFrameCompRight(right);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingFrameCompRight() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingFrameCompRight();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 15;
        }
    }

    public boolean setTilingFrameCompEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingFrameCompEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getTilingFrameCompEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingFrameCompEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setTilingEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setTilingEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getTilingEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getTilingEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadCusOverScanSettings() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().loadCusOverScanSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setOverscanParams(int[] params) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setOverscanParams(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDynamicContrastEnable(boolean enable) {
        if (enable) {
            return this.setLumaType(2);
        }
        return this.setLumaType(0);
    }

    public boolean getDynamicContrastEnable() {
        int lumaType = this.getLumaType();
        return lumaType != 0;
    }

    public boolean setLumaType(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setLumaType(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLumaType() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getLumaType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setPicColorTune(int hsyModel, int hsyColor, int value) {
        try {
            if (hsyColor == 4) {
                hsyColor = 5;
            } else if (hsyColor == 5) {
                hsyColor = 4;
            }
            return XbhAidlApi.getInstance().getPicInterface().setPicColorTune(hsyColor, hsyModel, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPicColorTune(int hsyModel, int hsyColor) {
        try {
            if (hsyColor == 4) {
                hsyColor = 5;
            } else if (hsyColor == 5) {
                hsyColor = 4;
            }
            return XbhAidlApi.getInstance().getPicInterface().getPicColorTune(hsyColor, hsyModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDefaultPicColorTune(int hsyModel, int hsyColor) {
        try {
            HisenseManager.getInstance().getDefaultPicColorTune(hsyModel, hsyColor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 50;
    }

    public void initDefaultPicColorTuneData() {
        try {
            HisenseManager.getInstance().initDefaultPicColorTuneData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getDefaultBacklight(int vaule) {
        try {
            return 80;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 80;
        }
    }

    public boolean setGameModeEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setGameModeEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getGameModeEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getGameModeEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPicturePcMode(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPicturePcMode(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getPicturePcMode() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPicturePcMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPicPqWbCorEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPicPqWbCorEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getPicPqWbCorEnable() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPicPqWbCorEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPicPqWbCorGain(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPicPqWbCorGain(value *= 10);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPicPqWbCorGain() {
        try {
            int gain = XbhAidlApi.getInstance().getPicInterface().getPicPqWbCorGain();
            return gain /= 10;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setPicPqWbCorRed(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPicPqWbCorRed(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPicPqWbCorRed() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPicPqWbCorRed();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public boolean setPicPqWbCorGreen(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPicPqWbCorGreen(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPicPqWbCorGreen() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPicPqWbCorGreen();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public boolean setPicPqWbCorBlue(int value) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setPicPqWbCorBlue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPicPqWbCorBlue() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getPicPqWbCorBlue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDefaultgetPicPqWbCorRed() {
        try {
            return HisenseManager.getInstance().getDefaultgetPicPqWbCorRed();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDefaultgetPicPqWbCorGreen() {
        try {
            return HisenseManager.getInstance().getDefaultgetPicPqWbCorGreen();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDefaultgetPicPqWbCorBlue() {
        try {
            return HisenseManager.getInstance().getDefaultgetPicPqWbCorBlue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public boolean setColorSpace(int type) {
        try {
            return XbhAidlApi.getInstance().getPicInterface().setColorSpace(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getColorSpace() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getColorSpace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCustomColorSpace(int type) {
        return HisenseManager.getInstance().setCustomColorSpace(type);
    }

    public int getCustomColorSpace() {
        return HisenseManager.getInstance().getCustomColorSpace();
    }

    public int getSignalColorSpace() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getSignalColorSpace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setMemc(int index) {
        return HisenseManager.getInstance().setMemc(index);
    }

    public int getMemc() {
        return HisenseManager.getInstance().getMemc();
    }

    public boolean setTilingSource(int srcIdx) {
        try {
            Log.d((String)TAG, (String)("srcIdx = " + srcIdx));
            return XbhAidlApi.getInstance().getPicInterface().setTilingSource(MULTI_SOURCE_LIST[srcIdx]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingSource() {
        try {
            return Arrays.binarySearch(MULTI_SOURCE_LIST, XbhAidlApi.getInstance().getPicInterface().getTilingSource());
        }
        catch (Exception e) {
            e.printStackTrace();
            return MULTI_SOURCE_LIST.length - 1;
        }
    }

    public boolean setFactoryBacklight(int vaule) {
        return HisenseManager.getInstance().setFactoryBacklight(vaule);
    }

    public int getFactoryBacklight() {
        return HisenseManager.getInstance().getFactoryBacklight();
    }

    public boolean setGammaByPass(boolean enable) {
        return HisenseManager.getInstance().setGammaByPass(enable);
    }

    public boolean getGammaByPass() {
        return HisenseManager.getInstance().getGammaByPass();
    }

    public boolean setLocalDimming(int mode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setLocalDimming(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLocalDimming() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getLocalDimming();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setLocalDimmingCustomMode(int customMode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setLocalDimmingCustomMode(customMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLocalDimmingCustomMode() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getLocalDimmingCustomMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean generateGopTestPatternByBmp(String path, int width, int height) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().generateGopTestPatternByBmp(path, width, height);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int generateGopTestPatternOn(int width, int height) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().generateGopTestPatternOn(width, height);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int generateGopTestPatternOff() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().generateGopTestPatternOff();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int generateGopTestPatternShow() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().generateGopTestPatternShow();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int generateGopTestPatternHide() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().generateGopTestPatternHide();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setPqOnOff(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setPqOnOff(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

