/*
 * Decompiled with CFR 0.152.
 */
package com.hisense.hotel;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;
import com.android.server.hisense.IEthernetListener;
import com.android.server.hisense.IHisenseAidlInterface;
import com.hisense.hotel.IServicesReadyListener;

public class HisenseManager {
    private static final String TAG = HisenseManager.class.getSimpleName();
    private IHisenseAidlInterface mService;
    private static HisenseManager INSTANCE;
    private static final int DELAY_MILLIS = 500;
    private static final int BIND_AIDL_SERVICE = 1001;
    private Context mContext;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1001) {
                Log.d((String)TAG, (String)("handleMessage: mService=" + HisenseManager.this.mService));
                if (HisenseManager.this.mService == null) {
                    boolean isBind = HisenseManager.this.bindAidlService();
                    Log.i((String)TAG, (String)("isBind:  " + isBind));
                    this.sendEmptyMessageDelayed(1001, 500L);
                }
            }
        }
    };
    private final ServiceConnection mConn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d((String)TAG, (String)"onServiceConnected");
            HisenseManager.this.mService = IHisenseAidlInterface.Stub.asInterface(service);
            if (HisenseManager.this.mService == null) {
                return;
            }
            HisenseManager.this.mHandler.removeMessages(1001);
            try {
                if (HisenseManager.this.mIServicesReadyListener != null) {
                    HisenseManager.this.mIServicesReadyListener.allServicesReady();
                }
                HisenseManager.this.mService.asBinder().linkToDeath(HisenseManager.this.mDeathRecipient, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            HisenseManager.this.mService = null;
            Log.d((String)TAG, (String)"onServiceDisconnected");
        }
    };
    private final IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            Log.e((String)TAG, (String)"binderDied");
            HisenseManager.this.unbindAidlService();
            HisenseManager.this.mHandler.sendEmptyMessage(1001);
        }
    };
    IServicesReadyListener mIServicesReadyListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisenseManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<HisenseManager> clazz = HisenseManager.class;
        synchronized (HisenseManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HisenseManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private boolean bindAidlService() {
        Log.i((String)TAG, (String)"bindAidlService");
        Intent intent = new Intent();
        intent.setAction("com.android.server.hisense.HisenseService");
        intent.setPackage("com.xbh.sdk.demo");
        return this.mContext.bindService(intent, this.mConn, 1);
    }

    private void unbindAidlService() {
        if (this.mService != null) {
            Log.i((String)TAG, (String)"unbindAidlService");
            this.mContext.unbindService(this.mConn);
            this.mService.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
            this.mService = null;
        }
    }

    public void init(Context context) {
        Log.d((String)TAG, (String)"init: ");
        this.mContext = context;
        this.mHandler.sendEmptyMessage(1001);
    }

    public void close() {
        this.unbindAidlService();
    }

    public void addServiceReadyListener(IServicesReadyListener iServicesReadyListener) {
        this.mIServicesReadyListener = iServicesReadyListener;
    }

    public void startShowInternalImage(int type) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.startShowInternalImage(type);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stoptShowInternalImage() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.stoptShowInternalImage();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setInternalImagepattern(int level) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setInternalImagepattern(level);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setToFacUiState(int state) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setToFacUiState(state);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getToFacUiState() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getToFacUiState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setFactoryState(int state) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryState(state);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getFactoryState() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getFactoryState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setFactoryMac() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryMac();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setFactoryHdcp22() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryHdcp22();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setFactoryHdcp14() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryHdcp14();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setFactoryCountry() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryCountry();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getFactoryCountry() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getFactoryCountry();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setScreenCheck(int pattern) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setScreenCheck(pattern);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void clearMotherBlock() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.clearMotherBlock();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void startFactoryState() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.startFactoryState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getEnergySavingMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getEnergySavingMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setEnergySavingMode(int mode) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setEnergySavingMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void startAgingMode() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.startAgingMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stopAgingMode() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.stopAgingMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getAgingModeState() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getAgingModeState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void showSnowPattern(boolean show) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.showSnowPattern(show);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getUsageTime() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getUsageTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setUsageTime(int time) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setUsageTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getFactoryLanguage() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getFactoryLanguage();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setFactoryLanguageEnv(String factoryLanguage) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setFactoryLanguageEnv(factoryLanguage);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setFactoryLanguage() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryLanguage();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setFactoryResetState(int state) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFactoryResetState(state);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getFactoryResetState() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getFactoryResetState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setTimeZone(String olsonId) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setTimeZone(olsonId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getTconType() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getTconType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int[] getTconDevAddr(int type) {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getTconDevAddr(type);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getVcomValue() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getVcomValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setVcomvalue(int vcomvalue) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setVcomvalue(vcomvalue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void processF6saveVcom() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.processF6saveVcom();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean setCustomColorTempModePara(int mode, int[] para) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCustomColorTempModePara(mode, para);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setUserColorTempModePara(int mode, int[] para) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setUserColorTempModePara(mode, para);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getCustomColorTempModePara(int mode) {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getCustomColorTempModePara(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int[] getUserColorTempModePara(int mode) {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getUserColorTempModePara(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getUserColorTempMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getUserColorTempMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getCustomColorTempMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getCustomColorTempMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCustomColorTempMode(int mode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCustomColorTempMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCustomColorTempModeByForce(int mode, boolean force) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCustomColorTempModeByForce(mode, force);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setUserColorTempMode(int mode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setUserColorTempMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setUserColorTempModeByForce(int mode, boolean force) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setUserColorTempModeByForce(mode, force);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setScreenRotarion(int rotation) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setScreenRotarion(rotation);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getScreenRotarion() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getScreenRotarion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setMenuRotarion(int rotation) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setMenuRotarion(rotation);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getMenuRotarion() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getMenuRotarion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getSystemProperties(String key, String defaultValue) {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getSystemProperties(key, defaultValue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setSystemProperties(String key, String value) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setSystemProperties(key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stopFactoryState() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.stopFactoryState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void resetCustomPictureSettings() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.resetCustomPictureSettings();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int[] getDefaultCustomColorTempModePara(int mode) {
        if (this.mService == null) {
            return new int[6];
        }
        try {
            return this.mService.getDefaultCustomColorTempModePara(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new int[6];
        }
    }

    public void initDefaultPicColorTuneData() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.initDefaultPicColorTuneData();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getDefaultPicColorTune(int hsyModel, int hsyColor) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getDefaultPicColorTune(hsyModel, hsyColor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public boolean setHisenseSerialNum(String sn) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setHisenseSerialNum(sn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getHisenseSerialNum() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getHisenseSerialNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getFristHisenseSerialNum() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getFristHisenseSerialNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getDefaultgetPicPqWbCorRed() {
        if (this.mService == null) {
            return 50;
        }
        try {
            return this.mService.getDefaultgetPicPqWbCorRed();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDefaultgetPicPqWbCorGreen() {
        if (this.mService == null) {
            return 50;
        }
        try {
            return this.mService.getDefaultgetPicPqWbCorGreen();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDefaultgetPicPqWbCorBlue() {
        if (this.mService == null) {
            return 50;
        }
        try {
            return this.mService.getDefaultgetPicPqWbCorBlue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public boolean setNoSignalStandby(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setNoSignalStandby(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getNoSignalStandby() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getNoSignalStandby();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getdefaultBalance() {
        if (this.mService == null) {
            return 50;
        }
        try {
            return this.mService.getdefaultBalance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 50;
        }
    }

    public boolean setCurrentVolumeMin(int volume) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCurrentVolumeMin(volume);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCurrentVolumeMin() {
        if (this.mService == null) {
            return 0;
        }
        int res = 0;
        try {
            res = this.mService.getCurrentVolumeMin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setPowerOnDelayEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setPowerOnDelayEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getPowerOnDelayEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getPowerOnDelayEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPowerOnDelay(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setPowerOnDelay(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPowerOnDelay() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getPowerOnDelay();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setBootPlayListSourceEnable(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setBootPlayListSourceEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getBootPlayListSourceEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getBootPlayListSourceEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setFakePowerOff(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFakePowerOff(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getFakePowerOff() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getFakePowerOff();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSourceBakEnable(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setSourceBakEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getSourceBakEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getSourceBakEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSourceBakMasterChannel(int channel) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setSourceBakMasterChannel(channel);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getSourceBakMasterChannel() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getSourceBakMasterChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setSourceBakSlaveChannel(int channel) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setSourceBakSlaveChannel(channel);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getSourceBakSlaveChannel() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getSourceBakSlaveChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getEthernetIPv6Address() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getEthernetIPv6Address();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getWifiIPv6Address() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getWifiIPv6Address();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setCecIrControlEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCecIrControlEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getCecIrControlEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getCecIrControlEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setDefaultLauncher(String pkgName) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setDefaultLauncher(pkgName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDefaultLauncher() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getDefaultLauncher();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setWifiApEnableByConfig(String SSID, String password, int allowedKeyManagement, int apChannel) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setWifiApEnableByConfig(SSID, password, allowedKeyManagement, apChannel);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setMonitorId(String monitorId) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setMonitorId(monitorId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMonitorId() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getMonitorId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getDreamStartTime() {
        if (this.mService == null) {
            return 0L;
        }
        try {
            return this.mService.getDreamStartTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void setDreamStartTime(long value) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setDreamStartTime(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setDreamControlEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setDreamControlEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getDreamControlEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getDreamControlEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDreamPath() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getDreamPath();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDreamPath(String path) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setDreamPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getDefaulteqvalue() {
        if (this.mService == null) {
            return 50;
        }
        try {
            return this.mService.getDefaulteqvalue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getDreamType() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getDreamType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setDreamType(int value) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setDreamType(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNoSignalPicPath() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getNoSignalPicPath();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setNoSignalPicPath(String path) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setNoSignalPicPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getNoSignalPicType() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getNoSignalPicType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setNoSignalPicType(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setNoSignalPicType(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setFirstTempProtectFlag(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFirstTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getFirstTempProtectFlag() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getFirstTempProtectFlag();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSecondTempProtectFlag(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setSecondTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getSecondTempProtectFlag() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getSecondTempProtectFlag();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setThirdTempProtectFlag(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setThirdTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getThirdTempProtectFlag() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getThirdTempProtectFlag();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setNoSignalStandbyEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setNoSignalStandbyEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getNoSignalStandbyEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getNoSignalStandbyEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCustomPictureMode(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCustomPictureMode(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCustomPictureMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getCustomPictureMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean restoreSystemSettings() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.restoreSystemSettings();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBootLogo(String path, boolean isSave) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBootLogo(path, isSave);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getBootLogo(boolean isSave) {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getBootLogo(isSave);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setBootAnimation(String path, boolean isSave) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBootAnimation(path, isSave);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getBootAnimation(boolean isSave) {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getBootAnimation(isSave);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean showVcomView(boolean show) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.showVcomView(show);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setAudioChannel(int type) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setAudioChannel(type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getAudioChannel() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getAudioChannel();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCustomWifiApEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.setCustomWifiApEnable(enable);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setVideoRotation(int rotation) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setVideoRotation(rotation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getVideoRotation() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getVideoRotation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void clearHdcpKey() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.clearHdcpKey();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean setFactoryCountryEnv(String countryEnv) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setFactoryCountryEnv(countryEnv);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.setCecEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean getCecEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getCecEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecAutoPowerOffEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.setCecAutoPowerOffEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean getCecAutoPowerOffEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getCecAutoPowerOffEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecAutoWakeUpEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.setCecAutoWakeUpEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean getCecAutoWakeUpEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getCecAutoWakeUpEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getSoftwareVersion() {
        Log.d((String)TAG, (String)"getSoftwareVersion");
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getSoftwareVersion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getDeviceID() {
        Log.d((String)TAG, (String)"getDeviceID");
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getDeviceID();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSerialNumber() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getSerialNumber();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void shotScreen(String path) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.shotScreen(path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean injectKey(int keyCode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.injectKey(keyCode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startSystemSettingMenu() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.startSystemSettingMenu();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean shutdownSystem() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.shutdownSystem();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBootModel(int model) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBootModel(model);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBootModel() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getBootModel();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean shutdownScreen(int model) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.shutdownScreen(model);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean installSilentApp(String packageName, String path) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.installSilentApp(packageName, path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean uninstallApp(String packageName) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.uninstallApp(packageName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setVolume(int volume) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setVolume(volume);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getVolume() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getVolume();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setMuteFlag(boolean flag) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setMuteFlag(flag);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getMuteFlag() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getMuteFlag();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDefaultVolume(int volume) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setDefaultVolume(volume);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getDefaultVolume() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getDefaultVolume();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setMaxVolume(int volume) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setMaxVolume(volume);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getMaxVolume() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getMaxVolume();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void rebootDevice() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.rebootDevice();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean setOTAUpgradeEnable(boolean enabled) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setOTAUpgradeEnable(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getOTAUpgradeEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getOTAUpgradeEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean installOTAPackage(String path) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.installOTAPackage(path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSystemTime_Year(int year, int month, int day) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setSystemTime_Year(year, month, day);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSystemTime_Hour(int hour, int minute, int second) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setSystemTime_Hour(hour, minute, second);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setWhiteBalanceGain(int[] rgb) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setWhiteBalanceGain(rgb);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getWhiteBalanceGain() {
        if (this.mService == null) {
            return new int[3];
        }
        try {
            return this.mService.getWhiteBalanceGain();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new int[3];
        }
    }

    public boolean setWhiteBalanceOffset(int[] rgb) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setWhiteBalanceOffset(rgb);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getWhiteBalanceOffset() {
        if (this.mService == null) {
            return new int[3];
        }
        try {
            return this.mService.getWhiteBalanceOffset();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new int[3];
        }
    }

    public boolean setCurrentInputSource(int source, String packagename) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCurrentInputSource(source, packagename);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCurrentInputSource() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getCurrentInputSource();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setStartupInputSource(int source) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setStartupInputSource(source);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getStartupInputSource() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getStartupInputSource();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setBrightness(int bright) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBrightness(bright);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBrightness() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getBrightness();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setContrast(int contrast) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setContrast(contrast);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getContrast() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getContrast();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setBackLightValue(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBackLightValue(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBackLightValue() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getBackLightValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setSaturation(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setSaturation(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSaturation() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getSaturation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setSourceWindow(Rect rect) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setSourceWindow(rect);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setGammaMode(int mode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setGammaMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getGammaMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getGammaMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setDynamicContrast(boolean isEnable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setDynamicContrast(isEnable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getDynamicContrast() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getDynamicContrast();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setColorCorrection(int mode, int[] params) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setColorCorrection(mode, params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getColorCorrection(int mode) {
        if (this.mService == null) {
            return new int[3];
        }
        try {
            return this.mService.getColorCorrection(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new int[3];
        }
    }

    public int getNetType() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getNetType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getIpAddress() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getIpAddress();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getMacAddress() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getMacAddress();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isWiFiConnected() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isWiFiConnected();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isEthernetNetworkConnected() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isEthernetNetworkConnected();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void connectWifi(String ssid, String password, String security) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.connectWifi(ssid, password, security);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean autoConnectEthernet() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.autoConnectEthernet();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean manualConnectEthernet(String ip, String subnetMask, String gateway, String dns) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.manualConnectEthernet(ip, subnetMask, gateway, dns);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setWifiApState(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setWifiApState(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getWifiApState() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getWifiApState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setNoOpreationStandbyTime(int time) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setNoOpreationStandbyTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getNoOpreationStandbyTime() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getNoOpreationStandbyTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setMemc(int index) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setMemc(index);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getMemc() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getMemc();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCustomColorSpace(int type) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCustomColorSpace(type);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCustomColorSpace() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getCustomColorSpace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setTimedSwitch(boolean isPowerOff, boolean state, int year, int month, int day, int hour, int minute, int type, long timeStamp) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTimedSwitch(isPowerOff, state, year, month, day, hour, minute, type, timeStamp);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCA(String path) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setCA(path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getCA() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getCA();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean resetCustomSoundSettings() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.resetCustomSoundSettings();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSettingsDBValue(int type, String key, String value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setSettingsDBValue(type, key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setTimerSwitchInfo(boolean isPowerOff, boolean enable, int index, int type, int hour, int minute, int[] manualWeeks) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTimerSwitchInfo(isPowerOff, enable, index, type, hour, minute, manualWeeks);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSourceBakChannelExtra(String extra) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setSourceBakChannelExtra(extra);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getSourceBakChannelExtra() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getSourceBakChannelExtra();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void getInstalledPermissionSummary(String pkg) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.getInstalledPermissionSummary(pkg);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean setScreenProtectionEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectionEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getScreenProtectionEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getScreenProtectionEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setScreenProtectRegular(int regular) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectRegular(regular);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScreenProtectRegular() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getScreenProtectRegular();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setScreenProtectType(int type) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectType(type);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScreenProtectType() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getScreenProtectType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setScreenProtectStartTime(String time) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectStartTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getScreenProtectStartTime() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getScreenProtectStartTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setScreenProtectEndTime(String time) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectEndTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getScreenProtectEndTime() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getScreenProtectEndTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int showSource(String name, Surface surface, int x, int y, int w, int h, boolean isMute) {
        if (this.mService == null) {
            return -1;
        }
        try {
            return this.mService.showSource(name, surface, x, y, w, h, isMute);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int stopSource(int id) {
        if (this.mService == null) {
            return -1;
        }
        try {
            return this.mService.stopSource(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getEthernetMask() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getEthernetMask();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getEthernetGateWay() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getEthernetGateWay();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getEthernetDNS1() {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getEthernetDNS1();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getEthernetPlugState() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getEthernetPlugState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean registerEthernetListener(IEthernetListener listener) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.registerEthernetListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterEthernetListener(IEthernetListener listener) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.unRegisterEthernetListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setEthernetEnable(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setEthernetEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getEthernetEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getEthernetEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBass(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBass(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBass() {
        if (this.mService == null) {
            return -1;
        }
        try {
            return this.mService.getBass();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setTreble(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTreble(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTreble() {
        if (this.mService == null) {
            return -1;
        }
        try {
            return this.mService.getTreble();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setBalance(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBalance(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBalance() {
        if (this.mService == null) {
            return -1;
        }
        try {
            return this.mService.getBalance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSoundMode(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setSoundMode(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSoundMode() {
        if (this.mService == null) {
            return -1;
        }
        try {
            return this.mService.getSoundMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setAvcEnable(boolean isAvcEnable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setAvcEnable(isAvcEnable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getAvcEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getAvcEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPixelShiftEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setPixelShiftEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getPixelShiftEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getPixelShiftEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPixelShiftHRange(int hRange) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setPixelShiftHRange(hRange);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPixelShiftHRange() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getPixelShiftHRange();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setPixelShiftVRange(int vRange) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setPixelShiftVRange(vRange);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPixelShiftVRange() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getPixelShiftVRange();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setPixelShiftTime(int time) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setPixelShiftTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPixelShiftTime() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getPixelShiftTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setOnLedEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setOnLedEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getOnLedEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getOnLedEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setOffLedEnable(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setOffLedEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getOffLedEnable() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getOffLedEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setScreenProtectCycle(int cycle) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectCycle(cycle);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScreenProtectCycle() {
        if (this.mService == null) {
            return 1;
        }
        try {
            return this.mService.getScreenProtectCycle();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setScreenProtectExcTime(int time) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectExcTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScreenProtectExcTime() {
        if (this.mService == null) {
            return 10;
        }
        try {
            return this.mService.getScreenProtectExcTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 10;
        }
    }

    public boolean setScreenProtectImmediateMode(int mode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setScreenProtectImmediateMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScreenProtectImmediateMode() {
        if (this.mService == null) {
            return 3;
        }
        try {
            return this.mService.getScreenProtectImmediateMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 3;
        }
    }

    public boolean setFactoryBacklight(int vaule) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setFactoryBacklight(vaule);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getFactoryBacklight() {
        if (this.mService == null) {
            return 100;
        }
        try {
            return this.mService.getFactoryBacklight();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 100;
        }
    }

    public boolean setTilingHorMonitorNum(int num) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTilingHorMonitorNum(num);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingHorMonitorNum() {
        if (this.mService == null) {
            return 1;
        }
        try {
            return this.mService.getTilingHorMonitorNum();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setTilingVerMonitorNum(int num) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTilingVerMonitorNum(num);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingVerMonitorNum() {
        if (this.mService == null) {
            return 1;
        }
        try {
            return this.mService.getTilingVerMonitorNum();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setTilingCurPos(int position) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTilingCurPos(position);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingCurPos() {
        if (this.mService == null) {
            return 1;
        }
        try {
            return this.mService.getTilingCurPos();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public boolean setTilingSource(int srcIdx) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setTilingSource(srcIdx);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTilingSource() {
        if (this.mService == null) {
            return 1;
        }
        try {
            return this.mService.getTilingSource();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 3;
        }
    }

    public boolean setGammaByPass(boolean enable) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setGammaByPass(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getGammaByPass() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getGammaByPass();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getCustomModelName() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getCustomModelName();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setLocalDimming(int mode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setLocalDimming(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLocalDimming() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getLocalDimming();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setFanMode(int mode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setFanMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getFanMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getFanMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getFanSpeed(int fanId) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getFanSpeed(fanId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getFanState(int fanId) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getFanState(fanId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setFanSpeed(int fanId, int speed) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setFanSpeed(fanId, speed);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBacklightMax(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBacklightMax(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBacklightMax() {
        if (this.mService == null) {
            return 100;
        }
        try {
            return this.mService.getBacklightMax();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 100;
        }
    }

    public boolean setBacklightMin(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setBacklightMin(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBacklightMin() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getBacklightMin();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setAmbientLightMax(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setAmbientLightMax(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAmbientLightMax() {
        if (this.mService == null) {
            return 100;
        }
        try {
            return this.mService.getAmbientLightMax();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setAmbientLightMin(int value) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setAmbientLightMin(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAmbientLightMin() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getAmbientLightMin();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getFanRealSpeed(int fanId) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getFanRealSpeed(fanId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setLightSensorData(String lightSensorListStr) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setLightSensorData(lightSensorListStr);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getLightSensorData() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getLightSensorData();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getLDVersion() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getLDVersion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean getHasOtaNewVersion() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getHasOtaNewVersion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean startOtaUpdate() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.startOtaUpdate();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getLDStatus() {
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getLDStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setFourthTempProtectFlag(boolean enable) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setFourthTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getFourthTempProtectFlag() {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.getFourthTempProtectFlag();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setLocalDimmingCustomMode(int customMode) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.setLocalDimmingCustomMode(customMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLocalDimmingCustomMode() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getLocalDimmingCustomMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

