/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.window;

import android.content.Intent;
import android.graphics.Rect;
import android.os.RemoteException;
import com.xbh.unf.System.XbhStackInfo;
import java.util.List;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.IWindowListener;

public class WindowHelper {
    private static final String TAG = "XBH-SDK-" + WindowHelper.class.getSimpleName();

    public boolean registerWindowListener(IWindowListener listener) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().registerWindowListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterWindowListener(IWindowListener listener) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().unRegisterWindowListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean startSplitScreenMode(boolean dockTopLeft, Intent intent) {
        try {
            String paramIntent = intent.toUri(0);
            return XbhAidlApi.getInstance().getWindowInterface().startSplitScreenMode(dockTopLeft, paramIntent);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean dismissSplitScreenMode(boolean isLeftTop) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().dismissSplitScreenMode(isLeftTop);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean swapDockedAndFullscreenStack() {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().swapDockedAndFullscreenStack();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean replaceSplitSreenWithStackId(boolean isLeftTop, Intent intent) {
        try {
            String paramIntent = intent.toUri(0);
            return XbhAidlApi.getInstance().getWindowInterface().replaceSplitSreenWithStackId(isLeftTop, paramIntent);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isInMultiWindowMode() {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().isInMultiWindowMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public XbhStackInfo getSplitScreenPrimaryStack() {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().getSplitScreenPrimaryStack();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public XbhStackInfo getSplitScreenSecondStack() {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().getSplitScreenSecondStack();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean startFreedomMode(Intent intent, int left, int top, int width, int height) {
        try {
            String paramIntent = intent.toUri(0);
            return XbhAidlApi.getInstance().getWindowInterface().startFreedomMode(paramIntent, left, top, width, height);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean dismissFreedomMode(Intent intent, boolean isTop) {
        try {
            String paramIntent = intent.toUri(0);
            return XbhAidlApi.getInstance().getWindowInterface().dismissFreedomMode(paramIntent, isTop);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isAppSupportMultiWindowMode(Intent intent, int mode, boolean isForceFilter) {
        try {
            String paramIntent = intent.toUri(0);
            return XbhAidlApi.getInstance().getWindowInterface().isAppSupportMultiWindowMode(paramIntent, mode, isForceFilter);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getMultiWindowModeAppList(int mode) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().getMultiWindowModeAppList(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<XbhStackInfo> getStackInfos(int mode, boolean onlyVisible) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().getStackInfos(mode, onlyVisible);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean resizeTask(int taskId, int left, int top, int right, int bottom) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().resizeTask(taskId, left, top, right, bottom);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean switchFreeFormWindowMode(int taskId, boolean withAnim, int mode) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().switchFreeFormWindowMode(taskId, withAnim, mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean screenShotFreedomInsertWB(int left, int top, int width, int height) {
        try {
            return XbhAidlApi.getInstance().getWindowInterface().screenShotFreedomInsertWB(left, top, width, height);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void otherFreeFormWindowToSecondView(int taskId, boolean withAnim, boolean onlyVisible) {
        try {
            XbhAidlApi.getInstance().getWindowInterface().otherFreeFormWindowToSecondView(taskId, withAnim, onlyVisible);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void updateTouchScaleRect(Rect rect) {
        try {
            XbhAidlApi.getInstance().getWindowInterface().updateTouchScaleRect(rect);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

