/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.database;

import android.os.RemoteException;
import android.text.TextUtils;
import com.xbh.middleware.sdkprovider.contentprovider.EnumBooleanProvider;
import com.xbh.middleware.sdkprovider.contentprovider.EnumFloatProvider;
import com.xbh.middleware.sdkprovider.contentprovider.EnumIntegerProvider;
import com.xbh.middleware.sdkprovider.contentprovider.EnumStringProvider;
import com.xbh.middleware.sdkprovider.systemproperties.EnumProperties;
import com.xbh.sdk4.database.ConfigDataChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.IConfigListener;

public final class DatabaseHelper {
    private static final String TAG = "XBH-SDK-" + DatabaseHelper.class.getSimpleName();
    private static final String PERSIST_SYS_ENABLE_USB_DRIVE = "persist.sys.enable_usb_drive";
    private Map<String, List<ConfigDataChangeListener>> mListenerMap;
    private IConfigListener.Stub mConfigListener = new IConfigListener.Stub(){

        @Override
        public void onBooleanChange(String key, boolean value) throws RemoteException {
            List listenerList = (List)DatabaseHelper.this.mListenerMap.get(key);
            if (listenerList != null && listenerList.size() > 0) {
                for (ConfigDataChangeListener listener : listenerList) {
                    listener.onBooleanChange(key, value);
                }
            }
        }

        @Override
        public void onFloatChange(String key, float value) throws RemoteException {
            List listenerList = (List)DatabaseHelper.this.mListenerMap.get(key);
            if (listenerList != null && listenerList.size() > 0) {
                for (ConfigDataChangeListener listener : listenerList) {
                    listener.onFloatChange(key, value);
                }
            }
        }

        @Override
        public void onIntChange(String key, int value) throws RemoteException {
            List listenerList = (List)DatabaseHelper.this.mListenerMap.get(key);
            if (listenerList != null && listenerList.size() > 0) {
                for (ConfigDataChangeListener listener : listenerList) {
                    listener.onIntChange(key, value);
                }
            }
        }

        @Override
        public void onStringChange(String key, String value) throws RemoteException {
            List listenerList = (List)DatabaseHelper.this.mListenerMap.get(key);
            if (listenerList != null && listenerList.size() > 0) {
                for (ConfigDataChangeListener listener : listenerList) {
                    listener.onStringChange(key, value);
                }
            }
        }
    };

    public DatabaseHelper() {
        this.mListenerMap = new HashMap<String, List<ConfigDataChangeListener>>();
    }

    public boolean setBooleanDataFromProvider(EnumBooleanProvider func, boolean value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().setDataFromProviderByBool(func.name(), value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getBooleanDataFromProvider(EnumBooleanProvider func, boolean defValue) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByBool(func.name(), defValue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public boolean setFloatDataFromProvider(EnumFloatProvider func, float value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().setDataFromProviderByFloat(func.name(), value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public float getFloatDataFromProvider(EnumFloatProvider func, float defValue) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByFloat(func.name(), defValue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public boolean setIntDataFromProvider(EnumIntegerProvider func, int value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().setDataFromProviderByInt(func.name(), value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getIntDataFromProvider(EnumIntegerProvider func, int defValue) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByInt(func.name(), defValue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public boolean setStringDataFromProvider(EnumStringProvider func, String value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().setDataFromProviderByString(func.name(), value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getStringDataFromProvider(EnumStringProvider func) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByString(func.name(), null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getStringDataFromProvider(EnumStringProvider func, String defValue) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByString(func.name(), defValue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    private boolean registerConfigListener(String key, ConfigDataChangeListener listener) {
        List<ConfigDataChangeListener> listenerList = this.mListenerMap.get(key);
        if (listenerList == null) {
            try {
                XbhAidlApi.getInstance().getDatabaseInterface().registerConfigListener(key, this.mConfigListener);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return false;
            }
            listenerList = new ArrayList<ConfigDataChangeListener>();
            this.mListenerMap.put(key, listenerList);
        }
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
        return true;
    }

    private boolean unRegisterConfigListener(String key, ConfigDataChangeListener listener) {
        List<ConfigDataChangeListener> listenerList = this.mListenerMap.get(key);
        if (listenerList != null) {
            listenerList.remove(listener);
            if (listenerList.size() == 0) {
                try {
                    XbhAidlApi.getInstance().getDatabaseInterface().unRegisterConfigListener(key, this.mConfigListener);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                this.mListenerMap.remove(key);
            }
        }
        return true;
    }

    public boolean registerConfigListener(EnumBooleanProvider provider, ConfigDataChangeListener listener) {
        return this.registerConfigListener(provider.name(), listener);
    }

    public boolean registerConfigListener(EnumFloatProvider provider, ConfigDataChangeListener listener) {
        return this.registerConfigListener(provider.name(), listener);
    }

    public boolean registerConfigListener(EnumIntegerProvider provider, ConfigDataChangeListener listener) {
        return this.registerConfigListener(provider.name(), listener);
    }

    public boolean registerConfigListener(EnumStringProvider provider, ConfigDataChangeListener listener) {
        return this.registerConfigListener(provider.name(), listener);
    }

    public boolean unRegisterConfigListener(EnumBooleanProvider provider, ConfigDataChangeListener listener) {
        return this.unRegisterConfigListener(provider.name(), listener);
    }

    public boolean unRegisterConfigListener(EnumFloatProvider provider, ConfigDataChangeListener listener) {
        return this.unRegisterConfigListener(provider.name(), listener);
    }

    public boolean unRegisterConfigListener(EnumIntegerProvider provider, ConfigDataChangeListener listener) {
        return this.unRegisterConfigListener(provider.name(), listener);
    }

    public boolean unRegisterConfigListener(EnumStringProvider provider, ConfigDataChangeListener listener) {
        return this.unRegisterConfigListener(provider.name(), listener);
    }

    public boolean setSystemProperties(String key, String value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().setSystemProperties(key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getStringSystemProperties(String key) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties(key, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getStringSystemProperties(String key, String defValue) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties(key, defValue);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public int getIntSystemProperties(String key, int defValue) {
        try {
            return Integer.parseInt(XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties(key, String.valueOf(defValue)));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public long getLongSystemProperties(String key, long defValue) {
        try {
            return Long.parseLong(XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties(key, String.valueOf(defValue)));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public boolean getBooleanSystemProperties(String key, boolean defValue) {
        try {
            return Boolean.parseBoolean(XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties(key, String.valueOf(defValue)));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public boolean setStringSystemProperties(EnumProperties key, String value) {
        String propKey = this.getPropKeyByEnum(key);
        if (TextUtils.isEmpty((CharSequence)propKey)) {
            return false;
        }
        return this.setSystemProperties(propKey, value);
    }

    public String getStringSystemProperties(EnumProperties key, String defValue) {
        String propKey = this.getPropKeyByEnum(key);
        if (TextUtils.isEmpty((CharSequence)propKey)) {
            return null;
        }
        return this.getStringSystemProperties(propKey, defValue);
    }

    private String getPropKeyByEnum(EnumProperties key) {
        String propKey;
        switch (key) {
            case RO_PRODUCT_DEF_AP_NAME: {
                propKey = "ro.product.def.ap_name";
                break;
            }
            case RO_PRODUCT_DEF_AP_PASSWORD: {
                propKey = "ro.product.def.ap_password";
                break;
            }
            case RO_PRODUCT_CUSTOMER_CODE: {
                propKey = "ro.product.customer.ver";
                break;
            }
            case RO_PRODUCT_OTA_SERVER: {
                propKey = "ro.product.ota.server";
                break;
            }
            case RO_PRODUCT_CHIP_TYPE: {
                propKey = "ro.product.chip.type";
                break;
            }
            case RO_BACKLIGHT_AUTO_UI_ENABLE: {
                propKey = "ro.backlight.auto.ui.enable";
                break;
            }
            case RO_LANGO_SOURCE_HDMI4: {
                propKey = "ro.lango.SOURCE_HDMI4";
                break;
            }
            case RO_PRODUCT_BOARD_TYPE: {
                propKey = "ro.product.board.type";
                break;
            }
            case RO_NAVITIMER_ALARM_SOUND: {
                propKey = "ro.navitimer.alarm.sound";
                break;
            }
            case SYS_OTA_BOOT_FIRST: {
                propKey = "sys.ota.boot.first";
                break;
            }
            case SYS_KEY_LOCK_MODE: {
                propKey = "sys.key.lock.mode";
                break;
            }
            case SYS_HOTKEY_INTERCEPT: {
                propKey = "sys.hotkey.intercept";
                break;
            }
            case SYS_USB_SWITCH_STATUS: {
                propKey = "sys.usb.switch.status";
                break;
            }
            case SYS_DP_RES_STATUS: {
                propKey = "sys.dp.res.status";
                break;
            }
            case SYS_CONTROLPANEL_RESUME: {
                propKey = "sys.controlpanel.resume";
                break;
            }
            case SYS_SOURCEMENU_RESUME: {
                propKey = "sys.sourcemenu.resume";
                break;
            }
            case SYS_POWER_POWERDIALOGSHOW: {
                propKey = "sys.power.PowerDialogShow";
                break;
            }
            case SYS_XBH_TIMER_TIME: {
                propKey = "sys.xbh.timer.time";
                break;
            }
            case SYS_CHILDLOCK_CONFIRM_SHOWING: {
                propKey = "sys.childlock.confirm.showing";
                break;
            }
            case PERSIST_XBH_TWOFINGER_SLEEP: {
                propKey = "persist.xbh.twofinger.sleep";
                break;
            }
            case PERSIST_STANDBY_ENABLE: {
                propKey = "persist.standby.enable";
                break;
            }
            case PERSIST_STANDBY_TIMEOUT: {
                propKey = "persist.standby.timeout";
                break;
            }
            case PERSIST_LOCKSCREEN_TIMEOUT: {
                propKey = "persist.lockscreen.timeout";
                break;
            }
            case PERSIST_HARDWARE_WAKEUP: {
                propKey = "persist.hardware.wakeup";
                break;
            }
            case PERSIST_XBH_DATE_FORMAT: {
                propKey = "persist.xbh.date.format";
                break;
            }
            case PERSIST_XBH_TIME_FORMAT: {
                propKey = "persist.xbh.time.format";
                break;
            }
            case PERSIST_SYS_AGING_VIDEO: {
                propKey = "persist.sys.aging.video";
                break;
            }
            case PERSIST_SETUPWIZARD_COMPLETE: {
                propKey = "persist.setupwizard.complete";
                break;
            }
            case PERSIST_PRODUCT_CHILDLOCK: {
                propKey = "persist.product.childLock";
                break;
            }
            case PERSIST_PRODUCT_CHILDLOCK_CONFIRM: {
                propKey = "persist.product.childLock.confirm";
                break;
            }
            case PERSIST_SYS_STANDARD_MODE: {
                propKey = "persist.sys.standard_mode";
                break;
            }
            case PERSIST_SYS_DISPLAY_4K2K: {
                propKey = "persist.sys.display.4k2k";
                break;
            }
            case PERSIST_ENABLE_ORIGINAL_HANDWRITING: {
                propKey = "persist.enable.original.handwriting";
                break;
            }
            case PERSIST_SYS_XBH_ERASER_WIDTH: {
                propKey = "persist.sys.xbh.eraser_width";
                break;
            }
            case PERSIST_SYS_XBH_ERASER_HEIGHT: {
                propKey = "persist.sys.xbh.eraser_height";
                break;
            }
            case PERSIST_SYS_XBH_ERASER_FACTOR: {
                propKey = "persist.sys.xbh.eraser_factor";
                break;
            }
            case PERSIST_SYS_XBH_ERASER_MAX_WID: {
                propKey = "persist.sys.xbh.eraser_max_wid";
                break;
            }
            case PERSIST_THRESHOLD_SMALL_PENCIL_WIDTH: {
                propKey = "persist.threshold.small.pencil_width";
                break;
            }
            case PERSIST_THRESHOLD_SMALL_PENCIL_HEIGHT: {
                propKey = "persist.threshold.small.pencil_height";
                break;
            }
            case PERSIST_THRESHOLD_BIG_PENCIL_WIDTH: {
                propKey = "persist.threshold.big.pencil_width";
                break;
            }
            case PERSIST_THRESHOLD_BIG_PENCIL_HEIGHT: {
                propKey = "persist.threshold.big.pencil_height";
                break;
            }
            case PERSIST_SYS_STD_TOUCH_POINT: {
                propKey = "persist.sys.std_touch.point";
                break;
            }
            case PERSIST_SYS_SIM_TOUCH_POINT: {
                propKey = "persist.sys.sim_touch.point";
                break;
            }
            case PERSIST_SYS_EVENTDRAW: {
                propKey = "persist.sys.eventdraw";
                break;
            }
            case PERSIST_SYS_STANDARD_BIG_SMALL_ENABLE: {
                propKey = "persist.sys.standard.big_small.enable";
                break;
            }
            case PERSIST_SYS_QRCODE_IP: {
                propKey = "persist.sys.qrcode.ip";
                break;
            }
            case PERSIST_SIMPLE_ERASER_FACTOR: {
                propKey = "persist.simple.eraser_factor";
                break;
            }
            case PERSIST_SYS_WB_MAX_NUM: {
                propKey = "persist.sys.wb.max.num";
                break;
            }
            case PERSIST_SYS_WB_SHOW_SIMPLEMODE: {
                propKey = "persist.sis.wb.show.simplemode";
                break;
            }
            case PERSIST_SYS_LAUNCH_BROWSER: {
                propKey = "persist.sys.launch.browser";
                break;
            }
            case PERSIST_SYS_LAUNCH_CALCULATOR: {
                propKey = "persist.sys.launch.calculator";
                break;
            }
            case PERSIST_SYS_LAUNCH_CALENDAR: {
                propKey = "persist.sys.launch.calendar";
                break;
            }
            case PERSIST_SYS_LAUNCH_GALLERY: {
                propKey = "persist.sys.launch.gallery";
                break;
            }
            case PERSIST_SUS_LAUNCH_SCREENCAST: {
                propKey = "persist.sys.launch.screencast";
                break;
            }
            case PERSIST_TIMEOUT_OPS_SHUTDOWN: {
                propKey = "persist.timeout.ops.shutdown";
                break;
            }
            case PERSIST_TEMPTHRESHOLD_ENABLEFAN: {
                propKey = "persist.tempThreshold.enableFan";
                break;
            }
            case PERSIST_CONTROLFAN_CHECKCOUNT: {
                propKey = "persist.controlFan.checkCount";
                break;
            }
            case PERSIST_XBH_WARNING_TEMP: {
                propKey = "persist.xbh.warning.temp";
                break;
            }
            case PERSIST_XBH_STANDBY_TEMP: {
                propKey = "persist.xbh.standby.temp";
                break;
            }
            case PERSIST_LAUNCHER_MARQUEE_TYPE: {
                propKey = "persist.launcher.marquee.type";
                break;
            }
            case PERSIST_SYS_TIMEZONE: {
                propKey = "persist.sys.timezone";
                break;
            }
            case PERSIST_CUSTOM_OPS_SAVE: {
                propKey = "persist.custom.ops.save";
                break;
            }
            case PERSIST_CUSTOM_LIGHT_SAVE: {
                propKey = "persist.custom.light.save";
                break;
            }
            case PERSIST_SYS_POWER_EVENT: {
                propKey = "persist.sys.power.event";
                break;
            }
            case PERSIST_SYS_MUTE_STATE: {
                propKey = "persist.sys.mute.state";
                break;
            }
            case PERSIST_SYS_DEFSUBJECT: {
                propKey = "persist.sys.defsubject";
                break;
            }
            case PERSIST_XBH_APP_LOG_ENABLE: {
                propKey = "persist.xbh.app_log.enable";
                break;
            }
            case PERSIST_XBH_APP_LOGFILE_ENABLE: {
                propKey = "persist.xbh.app_logfile.enable";
                break;
            }
            case PERSIST_XBH_APP_CATCH_ENABLE: {
                propKey = "persist.xbh.app_catch.enable";
                break;
            }
            case PERSIST_SYS_NAVI_AUTOHIDE: {
                propKey = "persist.sys.navi.autohide";
                break;
            }
            case PERSIST_SYS_NAVI_AUTOHIDEMODEL: {
                propKey = "persist.sys.navi.autohidemodel";
                break;
            }
            case PERSIST_PRODUCT_SLIDEBARANIMATION: {
                propKey = "persist.product.slidebarAnimation";
                break;
            }
            case PERSIST_XBH_NAVIGATION_ENABLE: {
                propKey = "persist.xbh.navigation.enable";
                break;
            }
            case PERSIST_LISTENALONE_STATUS: {
                propKey = "persist.listenalone.status";
                break;
            }
            case PERSIST_SYS_OFFBLACKBOARDLIGHT: {
                propKey = "persist.sys.offblackboardlight";
                break;
            }
            case PERSIST_SYS_DISABLETV: {
                propKey = "persist.sys.disabletv";
                break;
            }
            case PERSIST_XBH_FLOATBALL_ENABLE: {
                propKey = "persist.xbh.floatball.enable";
                break;
            }
            case PERSIST_SYS_SCREEN_OFFSET_ENABLE: {
                propKey = "persist.xbh.screenoffset.enable";
                break;
            }
            case PERSIST_SYS_THREE_FINGER_GESTURES: {
                propKey = "persist.xbh.threefinger.gestures";
                break;
            }
            case PERSIST_SYS_DEFAULT_HOME_SOURCE: {
                propKey = "persist.xbh.default.homesource";
                break;
            }
            case TEMP_DISABLE_TOUCH_INDUCTION: {
                propKey = "temp.disable.touch.induction";
                break;
            }
            case SYSTEM_DRAWBOARD_ACTIVITY_ISSHOW: {
                propKey = "system.drawboard_activity.isshow";
                break;
            }
            case ENABLE_MUTE_BY_OFF_BLACK_BOARD: {
                propKey = "enableMuteByOffBlackBoard";
                break;
            }
            case AUDIO_VOLUME_SHOW_UI_FLAG: {
                propKey = "audio.volume.show_ui.flag";
                break;
            }
            default: {
                return "";
            }
        }
        return propKey;
    }

    public boolean setUSBDriveEnable(boolean b) {
        return this.setSystemProperties(PERSIST_SYS_ENABLE_USB_DRIVE, String.valueOf(b));
    }

    public boolean getUSBDriveEnable() {
        return this.getBooleanSystemProperties(PERSIST_SYS_ENABLE_USB_DRIVE, true);
    }

    public boolean setDataFromProviderByInt(String key, int value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().setDataFromProviderByInt(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getDataFromProviderByInt(String key, int value) {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByInt(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

