/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.unf4;

import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class PlatformLogUtil {
    public static final String XBH_SDK = "XBH-SDK-";
    private static final String TAG = "XBH-SDK-PlatformLogUtil";
    private static final HandlerThread HANDLER_THREAD = new HandlerThread();
    private static final String PERSIST_XBH_APP_LOGENABLE = "persist.xbh.app_log.enable";
    private static final String PERSIST_XBH_APP_LOGFILEENABLE = "persist.xbh.app_logfile.enable";
    private static final String PERSIST_XBH_APP_CATCHENABLE = "persist.xbh.app_catch.enable";
    private static final String PERSIST_LOGFILE_CACHE_SIZE = "persist.xbh.logfile_cache.size";
    private static final int MAX_OUTPUT_FILE_SIZE = 5120;
    private static final long MAX_SAVE_TIME = 604800000L;
    private static final long MAX_LOG_FILE_SIZE = 20480L;
    private static final int MAX_LOG_FILE_TOTAL = 100;
    private static final long MAX_LOG_DIR_AVAILABLE_SPACE_SIZE = 204800L;
    private static final long MAX_WRITE_FILE_LOG_CACHE_DATA_SIZE = 5L;
    private static final StringBuffer LOGBUFF = new StringBuffer();
    private static final int LAST_TIME_LOG_OUTTIME_CHECK_SPACE = 60000;
    private static final long MAX_WRITE_FILE_LOG_DATA_TOTAL = 1024L;
    private static final boolean isLogOpen;
    private static final boolean isOutputFileOpen;
    private static final boolean isCatchOpen;
    private static final long logStorageSize;
    private static CrashHandlerUtil crashHandlerUtil;
    private static long writeLogFileSize;
    private static long lastStorageSizeCheckTime;
    private static String logSavePath;
    private static boolean isRecordMsg;
    private static StringBuilder mStr;
    public static HashMap<String, String> mTotalResult;
    public static HashMap<String, String> mTotalManualResult;
    private static final String MATCH_FORMAT = "^\\d{4}-\\d{2}-\\d{2}-\\d{2}";
    private static final SimpleDateFormat MY_LOG_SDF;
    private static final SimpleDateFormat MY_LOGPRINT_TIME_SDF;
    private static final String LOG_FILE_SUFFIX = ".log";
    private static final int VERBOSE = 5;
    private static final int DEBUG = 4;
    private static final int INFO = 3;
    private static final int WARN = 2;
    private static final int ERROR = 1;

    public static synchronized void init(Application application) {
        if (application != null) {
            logSavePath = application.getExternalFilesDir("log").getAbsolutePath();
            PlatformLogUtil.init(application, logSavePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void init(Application application, String path) {
        if (application != null) {
            logSavePath = path;
        }
        Log.i((String)TAG, (String)("init: logSavePath:" + logSavePath));
        if (!isCatchOpen || TextUtils.isEmpty((CharSequence)logSavePath) || crashHandlerUtil != null) return;
        Class<PlatformLogUtil> clazz = PlatformLogUtil.class;
        synchronized (PlatformLogUtil.class) {
            if (crashHandlerUtil != null) return;
            crashHandlerUtil = new CrashHandlerUtil();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static String get(String key) {
        String getStr = null;
        try {
            Method getStringMethod = Class.forName("android.os.SystemProperties").getMethod("get", String.class);
            getStr = (String)getStringMethod.invoke(null, key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return getStr;
    }

    public static void log(String tag, Throwable throwable, int type) {
        if (crashHandlerUtil != null) {
            PlatformLogUtil.crashHandlerUtil.sendExceptionMsg(throwable);
        } else {
            PlatformLogUtil.log(tag, PlatformLogUtil.exToString(throwable), type);
        }
    }

    public static void log(String tag, String msg, int type) {
        switch (type) {
            case 5: {
                PlatformLogUtil.v(tag, msg);
                break;
            }
            case 4: {
                PlatformLogUtil.d(tag, msg);
                break;
            }
            case 3: {
                PlatformLogUtil.i(tag, msg);
                break;
            }
            case 2: {
                PlatformLogUtil.w(tag, msg);
                break;
            }
            case 1: {
                PlatformLogUtil.e(tag, msg);
                break;
            }
        }
    }

    public static void v(String tag, String msg) {
        if (isLogOpen) {
            Log.v((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
    }

    public static void d(String tag, String msg) {
        if (isLogOpen) {
            Log.d((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
    }

    public static void i(String tag, String msg) {
        if (isLogOpen) {
            Log.i((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
    }

    public static void w(String tag, String msg) {
        if (isLogOpen) {
            Log.w((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
    }

    public static void e(String tag, String msg) {
        if (isLogOpen) {
            Log.w((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
    }

    public static void at(String tag, String msg) {
        PlatformLogUtil.at(tag, "", msg);
    }

    public static void at(String tag, String functionName, String msg) {
        PlatformLogUtil.at(tag, functionName, false, msg);
    }

    public static void at(String tag, String functionName, boolean isManual, String msg) {
        if (isLogOpen) {
            Log.w((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
        if (isRecordMsg) {
            mStr.append("<font color='#000000'>" + msg + "</font><br />");
            if (functionName != null && !functionName.isEmpty() && !msg.startsWith("===")) {
                if (isManual) {
                    mTotalManualResult.put(functionName, "<font color='#000000'>" + msg + "</font><br />");
                } else {
                    mTotalResult.put(functionName, "<font color='#000000'>" + msg + "</font><br />");
                }
            }
        }
    }

    public static void ate(String tag, String msg) {
        PlatformLogUtil.ate(tag, "", msg);
    }

    public static void ate(String tag, String functionName, String msg) {
        PlatformLogUtil.ate(tag, functionName, false, msg);
    }

    public static void ate(String tag, String functionName, boolean isManual, String msg) {
        if (isLogOpen) {
            Log.w((String)tag, (String)msg);
        }
        PlatformLogUtil.logOutputToFile(tag, msg);
        if (isRecordMsg) {
            mStr.append("<font color='#FF0000'>" + msg + "</font><br />");
            if (isManual) {
                mTotalManualResult.put(functionName, "<font color='#FF0000'>" + msg + "</font><br />");
            } else {
                mTotalResult.put(functionName, "<font color='#FF0000'>" + msg + "</font><br />");
            }
        }
    }

    private static String exToString(Throwable ex) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        printWriter.close();
        return ((Object)writer).toString();
    }

    private static void logOutputToFile(String tag, String msg) {
        if (isOutputFileOpen) {
            PlatformLogUtil.addLogBuff(tag, msg);
            if (PlatformLogUtil.isCanWriteLogToFileFromBuffState()) {
                msg = LOGBUFF.toString();
                LOGBUFF.delete(0, LOGBUFF.length());
                Bundle data = new Bundle();
                data.putString("msg", msg);
                PlatformLogUtil.HANDLER_THREAD.sendMessage(1, data);
            }
        }
    }

    public static void setRecordMsg(boolean flag) {
        if (flag) {
            mStr.delete(0, mStr.length());
        }
        isRecordMsg = flag;
    }

    public static String getRecordMsg() {
        return mStr.toString();
    }

    private static boolean isCanWriteLogToFileFromBuffState() {
        return (long)LOGBUFF.length() >= 5120L;
    }

    private static void addLogBuff(String tag, String logMsg) {
        String logDate = MY_LOGPRINT_TIME_SDF.format(new Date());
        LOGBUFF.append(logDate).append(" ").append(tag).append(": ").append(logMsg).append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLogToFile(String logMsg) {
        PlatformLogUtil.calcPrintLogSize(logMsg);
        if (!PlatformLogUtil.checkSpace()) {
            Log.i((String)TAG, (String)"writeLogToFile: No Space!!!");
            return;
        }
        BufferedWriter bufWriter = null;
        if (!TextUtils.isEmpty((CharSequence)logSavePath)) {
            try {
                File dir = new File(logSavePath);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                String logFileName = MY_LOG_SDF.format(new Date()) + LOG_FILE_SUFFIX;
                File logFile = new File(logSavePath + File.separator + logFileName);
                bufWriter = new BufferedWriter(new FileWriter(logFile, true));
                bufWriter.write(logMsg);
                bufWriter.newLine();
                bufWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bufWriter != null) {
                    try {
                        bufWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                bufWriter = null;
            }
        }
    }

    private static boolean checkSpace() {
        if (!PlatformLogUtil.isNeedToDetect()) {
            return true;
        }
        File dir = new File(logSavePath);
        if (!dir.exists()) {
            return true;
        }
        try {
            double directoryFreeSpaceMB;
            if (dir.isFile()) {
                dir.delete();
                return true;
            }
            File[] logFiles = dir.listFiles();
            PlatformLogUtil.delLogChildDirectory(logFiles);
            logFiles = dir.listFiles();
            PlatformLogUtil.delMismatchFormLogFile(logFiles);
            logFiles = dir.listFiles();
            PlatformLogUtil.delExceedMaxLogSizeFile(logFiles);
            logFiles = dir.listFiles();
            PlatformLogUtil.delExceedMaxLogTotalFile(logFiles);
            logFiles = dir.listFiles();
            PlatformLogUtil.delExpiredLogFile(logFiles);
            logFiles = dir.listFiles();
            LinkedList<File> fileLinkedList = PlatformLogUtil.getSortedLogFileList(logFiles);
            long dirSize = PlatformLogUtil.getFileSizes(dir);
            Log.d((String)TAG, (String)("[checkSpace]: logStorageSize:" + logStorageSize + "KB  getFileSizes:" + dirSize + "B"));
            while (dirSize > logStorageSize * 1024L) {
                if (fileLinkedList.isEmpty()) {
                    Log.i((String)TAG, (String)"[checkSpace]: LogFileList is Empty...");
                    break;
                }
                File lastFile = fileLinkedList.removeLast();
                if (lastFile == null || !lastFile.exists()) continue;
                long length = lastFile.length();
                if (!lastFile.delete()) continue;
                Log.d((String)TAG, (String)("[checkSpace]: dirSize:" + (dirSize -= length)));
            }
            if ((directoryFreeSpaceMB = PlatformLogUtil.getDirectoryFreeSpaceMB(logSavePath)) < 200.0) {
                Log.d((String)TAG, (String)("[checkSpace]: crash dir size directoryFreeSpaceMB: " + directoryFreeSpaceMB));
                PlatformLogUtil.delAllLogFile();
            }
            return directoryFreeSpaceMB > 200.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void delLogChildDirectory(File[] logFiles) {
        if (logFiles != null) {
            for (File logFile : logFiles) {
                if (logFile == null || !logFile.exists() || !logFile.isDirectory()) continue;
                PlatformLogUtil.delFiles(logFile);
            }
        }
    }

    private static void delExceedMaxLogSizeFile(File[] logFiles) {
        if (logFiles != null) {
            for (File logFile : logFiles) {
                if (logFile == null || !logFile.exists() || logFile.length() < 0x1400000L) continue;
                PlatformLogUtil.delFiles(logFile);
            }
        }
    }

    private static void delMismatchFormLogFile(File[] logFiles) {
        if (logFiles != null) {
            for (File logFile : logFiles) {
                if (logFile == null || !logFile.exists()) continue;
                String name = logFile.getName();
                if (TextUtils.isEmpty((CharSequence)name)) {
                    PlatformLogUtil.delFiles(logFile);
                    continue;
                }
                if (name.endsWith(LOG_FILE_SUFFIX) || name.endsWith("_exception.trace")) {
                    name = name.endsWith(LOG_FILE_SUFFIX) ? name.replaceAll(LOG_FILE_SUFFIX, "") : name.replaceAll("_exception.trace", "");
                    Log.i((String)TAG, (String)("delMismatchFormLogFile: name:" + name + " matches:" + name.matches(MATCH_FORMAT)));
                    if (name.matches(MATCH_FORMAT)) continue;
                    PlatformLogUtil.delFiles(logFile);
                    continue;
                }
                PlatformLogUtil.delFiles(logFile);
            }
        }
    }

    private static void delExceedMaxLogTotalFile(File[] logFiles) {
        LinkedList<File> fileLinkedList;
        if (logFiles != null && logFiles.length >= 100 && (fileLinkedList = PlatformLogUtil.getSortedLogFileList(logFiles)) != null) {
            for (int size = fileLinkedList.size() - 50; size > 0; --size) {
                PlatformLogUtil.delFiles(fileLinkedList.removeLast());
            }
        }
    }

    private static boolean isNeedToDetect() {
        long currentTimeMillis = System.currentTimeMillis();
        if (lastStorageSizeCheckTime > 0L && Math.abs(currentTimeMillis - lastStorageSizeCheckTime) < 60000L && writeLogFileSize < 0x100000L) {
            return false;
        }
        writeLogFileSize = 0L;
        lastStorageSizeCheckTime = currentTimeMillis;
        return true;
    }

    private static LinkedList<File> getSortedLogFileList(File[] files) {
        LinkedList<File> fileLinkedList = new LinkedList<File>();
        if (files != null) {
            block0: for (File file1 : files) {
                if (fileLinkedList.isEmpty()) {
                    fileLinkedList.addLast(file1);
                    continue;
                }
                long currentTimeMillis = System.currentTimeMillis();
                long newLastModified = file1.lastModified();
                int i = 0;
                for (File fileLinked : fileLinkedList) {
                    long lastModified = fileLinked.lastModified();
                    if (Math.abs(currentTimeMillis - newLastModified) < Math.abs(currentTimeMillis - lastModified)) {
                        fileLinkedList.add(i, file1);
                        continue block0;
                    }
                    ++i;
                }
                fileLinkedList.addLast(file1);
            }
        }
        return fileLinkedList;
    }

    private static void delFiles(File file) {
        if (file != null && file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File file1 : files) {
                    PlatformLogUtil.delFiles(file1);
                }
            }
            file.delete();
        }
    }

    private static void delAllLogFile() {
        File[] files;
        Log.i((String)TAG, (String)"delAllLogFile: delete all Log File!");
        File file = new File(logSavePath);
        if (file.exists() && file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file1 : files) {
                file1.delete();
            }
        }
    }

    private static void delExpiredLogFile(File[] logFiles) {
        if (logFiles != null) {
            ArrayList<File> delfList = new ArrayList<File>();
            for (File file : logFiles) {
                long abs;
                long lastModified;
                if (file == null || !file.exists() || !file.isFile() || (lastModified = file.lastModified()) == 0L || (abs = Math.abs(System.currentTimeMillis() - lastModified)) <= 604800000L) continue;
                delfList.add(file);
            }
            for (File file : delfList) {
                file.delete();
            }
        }
    }

    private static double getDirectoryFreeSpaceMB(String path) {
        File root;
        if (!TextUtils.isEmpty((CharSequence)path) && (root = new File(path)).exists()) {
            return root.getFreeSpace() / 1024L / 1024L;
        }
        return -1.0;
    }

    private static long getFileSizes(File f) throws Exception {
        long size = 0L;
        if (f != null) {
            if (f.isDirectory()) {
                File[] flist;
                for (File file : flist = f.listFiles()) {
                    if (file == null || !file.exists()) continue;
                    size += file.length();
                }
            } else {
                size = f.length();
            }
        }
        return size;
    }

    private static long calcPrintLogSize(String logMsg) {
        byte[] bytes;
        if (!TextUtils.isEmpty((CharSequence)logMsg) && (bytes = logMsg.getBytes()) != null) {
            writeLogFileSize += (long)bytes.length;
        }
        return writeLogFileSize;
    }

    static {
        isRecordMsg = false;
        mStr = new StringBuilder();
        mTotalResult = new LinkedHashMap<String, String>();
        mTotalManualResult = new LinkedHashMap<String, String>();
        isLogOpen = "true".equals(PlatformLogUtil.get(PERSIST_XBH_APP_LOGENABLE));
        isOutputFileOpen = "true".equals(PlatformLogUtil.get(PERSIST_XBH_APP_LOGFILEENABLE));
        isCatchOpen = "true".equals(PlatformLogUtil.get(PERSIST_XBH_APP_CATCHENABLE));
        String logCacheSizeStr = PlatformLogUtil.get(PERSIST_LOGFILE_CACHE_SIZE);
        long logStorageL = TextUtils.isEmpty((CharSequence)logCacheSizeStr) ? 5120L : Long.parseLong(logCacheSizeStr);
        logStorageSize = logStorageL < 5L || logStorageL > 102400L ? 5120L : logStorageL;
        MY_LOG_SDF = new SimpleDateFormat("yyyy-MM-dd-HH");
        MY_LOGPRINT_TIME_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private static class HandlerThread
    implements Runnable {
        private static final int MSG_WRITE_LOG_FILE_CODE = 1;
        private static final int MSG_WRITE_CRASH_LOG_FILE_CODE = 2;
        private static final String MSG_WRITE_LOG_MSG_KEY = "msg";
        private static final String MSG_WRITE_EXCEPTION_LOG_MSG_KEY = "throwableMsg";
        private Handler mHandler;
        private Thread thread = new Thread(this);

        private HandlerThread() {
            this.thread.start();
        }

        public void removeMessages(int what) {
            this.mHandler.removeMessages(what);
        }

        private boolean sendMessage(int what, Bundle data) {
            if (data == null) {
                return false;
            }
            Message message = this.mHandler.obtainMessage();
            message.what = what;
            message.setData(data);
            return this.mHandler.sendMessage(message);
        }

        @Override
        public void run() {
            Log.i((String)PlatformLogUtil.TAG, (String)"HandlerThread run: =======start=====");
            Looper.prepare();
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.myLooper()){

                    public void handleMessage(Message msg) {
                        Bundle data = msg.getData();
                        switch (msg.what) {
                            case 1: {
                                PlatformLogUtil.writeLogToFile(data.getString(HandlerThread.MSG_WRITE_LOG_MSG_KEY, ""));
                                break;
                            }
                            case 2: {
                                Bundle bundle;
                                if (crashHandlerUtil == null || (bundle = msg.getData()) == null) break;
                                Throwable throwable = (Throwable)bundle.getSerializable(HandlerThread.MSG_WRITE_EXCEPTION_LOG_MSG_KEY);
                                crashHandlerUtil.dumpExceptionToSDCard(throwable);
                                break;
                            }
                        }
                    }
                };
            }
            Looper.loop();
            Log.i((String)PlatformLogUtil.TAG, (String)"HandlerThread run: =======end=====");
        }
    }

    private static class CrashHandlerUtil
    implements Thread.UncaughtExceptionHandler {
        private static final String ERROR_LOG_FILE_NAME_SUFFIX = "_exception.trace";
        private Thread.UncaughtExceptionHandler mDefaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();

        private CrashHandlerUtil() {
            Thread.setDefaultUncaughtExceptionHandler(this);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.sendExceptionMsg(e);
            e.printStackTrace();
            if (this.mDefaultUncaughtExceptionHandler != null) {
                this.mDefaultUncaughtExceptionHandler.uncaughtException(t, e);
            }
        }

        private void sendExceptionMsg(Throwable e) {
            Bundle data = new Bundle();
            data.putSerializable("throwableMsg", (Serializable)e);
            HANDLER_THREAD.sendMessage(2, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpExceptionToSDCard(Throwable e) {
            if (e == null) {
                Log.i((String)PlatformLogUtil.TAG, (String)"dumpExceptionToSDCard: Throwable is null!!");
                return;
            }
            PlatformLogUtil.calcPrintLogSize(e.getMessage());
            if (!PlatformLogUtil.checkSpace()) {
                Log.i((String)PlatformLogUtil.TAG, (String)"uncaughtException: No Space!!!");
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)logSavePath)) {
                File dir = new File(logSavePath);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                String logFileName = MY_LOG_SDF.format(new Date()) + ERROR_LOG_FILE_NAME_SUFFIX;
                File logFile = new File(logSavePath + File.separator + logFileName);
                try (PrintWriter printWriter = null;){
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(logFile, true)));
                    printWriter.println(MY_LOGPRINT_TIME_SDF.format(new Date()));
                    e.printStackTrace(printWriter);
                }
            }
        }
    }
}

