/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.tv;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.media.tv.TvContract;
import android.media.tv.TvView;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import com.xbh.sdk4.sourcemanager.SourceManagerHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import xbh.platform.aidl.listener.ISourceManagerListener;

public class TvManager {
    private static final String TAG = "TvManager";
    private static final String AUTO = "auto";
    private static final String HDMI1 = "hdmi1";
    private static final String HDMI2 = "hdmi2";
    private static final String DP = "dp";
    private static final int SUCCESS = 1;
    private static final int FAIL = -1;
    private String mName;
    private Surface mSurface;
    private int mX;
    private int mY;
    private int mW;
    private int mH;
    private boolean mIsMute;
    private volatile int lastSourceId = -1;
    @SuppressLint(value={"StaticFieldLeak"})
    private static TvManager instance;
    private TvView mTvView;
    private final SourceManagerHelper mSourceManagerHelper;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    ISourceManagerListener mISourceManagerListener = new ISourceManagerListener.Stub(){

        @Override
        public void OnSourcePlugIn(int i) throws RemoteException {
            Log.d((String)TvManager.TAG, (String)("OnSourcePlugIn: " + i + " source=" + TvManager.this.mName));
            if (TvManager.AUTO.equalsIgnoreCase(TvManager.this.mName)) {
                TvManager.this.showAvailSource(TvManager.this.mSurface, TvManager.this.mX, TvManager.this.mY, TvManager.this.mW, TvManager.this.mH, TvManager.this.mIsMute);
            }
        }

        @Override
        public void OnSourcePlugOut(int i) throws RemoteException {
            Log.d((String)TvManager.TAG, (String)("OnSourcePlugOut: " + i + " source=" + TvManager.this.mName));
            if (TvManager.this.lastSourceId == i) {
                TvManager.this.lastSourceId = -1;
            }
            if (TvManager.AUTO.equalsIgnoreCase(TvManager.this.mName)) {
                TvManager.this.showAvailSource(TvManager.this.mSurface, TvManager.this.mX, TvManager.this.mY, TvManager.this.mW, TvManager.this.mH, TvManager.this.mIsMute);
            }
        }

        @Override
        public void OnBeforeSourceSwitch(int i) throws RemoteException {
            Log.d((String)TvManager.TAG, (String)("OnBeforeSourceSwitch: " + i));
        }

        @Override
        public void OnSourceSelectComplete(int i) throws RemoteException {
        }

        @Override
        public void OnSourceSignalChanged(int i) throws RemoteException {
        }

        @Override
        public void OnSourceNameChanged(int i) throws RemoteException {
        }

        @Override
        public void OnAvailableInputsChanged(int i, boolean b) throws RemoteException {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TvManager getInstance() {
        if (instance != null) return instance;
        Class<TvManager> clazz = TvManager.class;
        synchronized (TvManager.class) {
            if (instance != null) return instance;
            instance = new TvManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TvManager() {
        Log.d((String)TAG, (String)"TvManager(): ");
        this.mSourceManagerHelper = new SourceManagerHelper();
        this.mSourceManagerHelper.registerSourceManagerListener(this.mISourceManagerListener);
    }

    public synchronized int showSource(String name, Surface surface, int x, int y, int w, int h, boolean isMute) {
        int sourceId;
        this.mName = name;
        this.mSurface = surface;
        this.mX = x;
        this.mY = y;
        this.mW = w;
        this.mH = h;
        this.mIsMute = isMute;
        this.lastSourceId = -1;
        Log.d((String)TAG, (String)("showSource: " + name));
        if (HDMI1.equalsIgnoreCase(name)) {
            sourceId = 9;
        } else if (HDMI2.equalsIgnoreCase(name)) {
            sourceId = 10;
        } else if (DP.equalsIgnoreCase(name)) {
            sourceId = 17;
        } else {
            if (AUTO.equalsIgnoreCase(name)) {
                this.showAvailSource(surface, x, y, w, h, isMute);
                return 1;
            }
            Log.e((String)TAG, (String)"showSource: illegal souceId");
            return -1;
        }
        this.stopSource(0);
        this.mHandler.postDelayed(() -> this.showSourceOnMain(sourceId, surface, x, y, w, h, isMute), 200L);
        return 1;
    }

    private synchronized void showAvailSource(Surface surface, int x, int y, int w, int h, boolean isMute) {
        List<Integer> availSourceList = this.mSourceManagerHelper.getAvailSourceList();
        if (availSourceList != null && availSourceList.size() > 0) {
            availSourceList.sort(Comparator.comparingInt(o -> o));
            Integer sourceId = availSourceList.get(0);
            if (this.lastSourceId == sourceId) {
                Log.e((String)TAG, (String)"showAvailSource: current souceId is the same of lastSourceId");
                return;
            }
            this.stopSource(0);
            Log.d((String)TAG, (String)("availSource id: " + sourceId));
            this.mHandler.postDelayed(() -> this.showSourceOnMain(sourceId, surface, x, y, w, h, isMute), 200L);
        }
    }

    private synchronized void showSourceOnMain(int sourceId, Surface surface, int x, int y, int w, int h, boolean isMute) {
        Application application = this.getApplicationByReflect();
        if (application == null) {
            Log.e((String)TAG, (String)"init reflect application fail");
            return;
        }
        Log.d((String)TAG, (String)"showSourceOnMain: ");
        if (this.mTvView == null) {
            this.mTvView = new TvView((Context)application);
        }
        this.setSurfaceAndTune(sourceId, surface, x, y, w, h, isMute);
        this.mHandler.postDelayed(() -> this.setSurfaceAndTune(sourceId, surface, x, y, w, h, isMute), 200L);
        this.lastSourceId = sourceId;
    }

    private void setSurfaceAndTune(int sourceId, Surface surface, int x, int y, int w, int h, boolean isMute) {
        Log.d((String)TAG, (String)("setSurfaceAndTune sourceId=" + sourceId));
        this.invokeTvSurface(surface);
        this.mSourceManagerHelper.changePreViewSource(sourceId, x, y, w, h, isMute, false);
        String tvInputId = this.mSourceManagerHelper.getCurPlatformSourceInputID(sourceId);
        if (TextUtils.isEmpty((CharSequence)tvInputId)) {
            Log.e((String)TAG, (String)"setSurfaceAndTune: tvInputId is null");
            return;
        }
        Uri channelUri = TvContract.buildChannelUriForPassthroughInput((String)tvInputId);
        this.mTvView.tune(tvInputId, channelUri);
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    private void invokeTvSurface(Surface surface) {
        if (this.mTvView == null) {
            Log.w((String)TAG, (String)"invokeTvSurface: mTvView is null");
            return;
        }
        try {
            Log.d((String)TAG, (String)("invokeTvSurface: " + this.mTvView));
            Class<?> tvViewClass = this.mTvView.getClass();
            Method methodSessionSurface = tvViewClass.getDeclaredMethod("setSessionSurface", Surface.class);
            methodSessionSurface.setAccessible(true);
            methodSessionSurface.invoke((Object)this.mTvView, surface);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("invokeTvSurface: " + e.getMessage()));
        }
    }

    public synchronized int stopSource(int id) {
        this.mHandler.post(() -> {
            Log.d((String)TAG, (String)"stopSource");
            this.invokeTvSurface(null);
            this.lastSourceId = -1;
            this.mTvView = null;
        });
        return 1;
    }

    private Application getApplicationByReflect() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object thread = this.getActivityThread();
            if (thread == null) {
                return null;
            }
            Object app = activityThreadClass.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                return null;
            }
            return (Application)app;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getActivityThread() {
        Object activityThread = this.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return this.getActivityThreadInActivityThreadStaticMethod();
    }

    private Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getActivityThreadInActivityThreadStaticField: " + e.getMessage()));
            return null;
        }
    }

    private Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getActivityThreadInActivityThreadStaticMethod: " + e.getMessage()));
            return null;
        }
    }
}

