/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.serialportservice;

import android.os.RemoteException;
import android.util.Log;
import java.util.Arrays;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.ISerialPortListener;

public class SerialPortHelper {
    private static final String TAG = "XBH-SDK-" + SerialPortHelper.class.getSimpleName();

    public boolean sendMsg(int portId, byte[] bytes) {
        try {
            Log.d((String)TAG, (String)("sendMsg +++++++++++++++++++++++++: =" + Arrays.toString(bytes)));
            return XbhAidlApi.getInstance().getSerialPortInterface().sendMsg(portId, bytes);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] receiveMsg(int portId) {
        try {
            return XbhAidlApi.getInstance().getSerialPortInterface().receiveMsg(portId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean openSerialPort(int portId, int baudRate) {
        try {
            return XbhAidlApi.getInstance().getSerialPortInterface().openSerialPort(portId, baudRate);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean closeSerialPort(int portId) {
        try {
            return XbhAidlApi.getInstance().getSerialPortInterface().closeSerialPort(portId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void registerSerialPortListener(int portId, ISerialPortListener listener) {
        try {
            XbhAidlApi.getInstance().getSerialPortInterface().registerSerialPortListener(portId, listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void unRegisterSerialPortListener(int portId, ISerialPortListener listener) {
        try {
            XbhAidlApi.getInstance().getSerialPortInterface().unRegisterSerialPortListener(portId, listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

