/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.multiuser;

import android.os.RemoteException;
import com.xbh.middleware.sdkprovider.multiuser.XbhUserInfo;
import com.xbh.middleware.sdkprovider.multiuser.XbhUserRestriction;
import java.util.List;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.IUserListener;

public class UserHelper {
    private static final String TAG = "XBH-SDK-" + UserHelper.class.getSimpleName();

    public boolean registerUserListener(IUserListener listener) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().registerUserListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterUserListener(IUserListener listener) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().unRegisterUserListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int createUser(XbhUserInfo userInfo) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().createUser(userInfo);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int removeUser(int uid) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().removeUser(uid);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateUser(XbhUserInfo userInfo) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().updateUser(userInfo);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public XbhUserInfo getUser(int uid) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().getUser(uid);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<XbhUserInfo> getUsers() {
        try {
            return XbhAidlApi.getInstance().getUserInterface().getUsers();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int switchUser(int uid, String psw) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().switchUser(uid, psw);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean hasUserRestriction(int uid, String restrictionKey) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().hasUserRestriction(uid, restrictionKey);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<XbhUserRestriction> getUserTypeRestrictions(String userType) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().getUserTypeRestrictions(userType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int setUserTypeRestrictions(String userType, List<XbhUserRestriction> restrictions) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().setUserTypeRestrictions(userType, restrictions);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int verifyUserPassword(int uid, String psw) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().verifyUserPassword(uid, psw);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int modifyUserPassword(int uid, String oldPsw, String newPsw) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().modifyUserPassword(uid, oldPsw, newPsw);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int resetUserPassword(int uid, String psw) {
        try {
            return XbhAidlApi.getInstance().getUserInterface().resetUserPassword(uid, psw);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

