/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.device;

import android.os.RemoteException;
import xbh.platform.aidl.XbhAidlApi;

public class DeviceHelper {
    private static final String TAG = "XBH-SDK-" + DeviceHelper.class.getSimpleName();

    public boolean setI2CData(int i2cAddr, int[] devAddr, int[] data) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().setI2CData(i2cAddr, devAddr, data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int[] getI2CData(int i2cAddr, int[] devAddr, int len) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().getI2CData(i2cAddr, devAddr, len);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setGpioData(int gpioIdx, boolean value) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().setGpioData(gpioIdx, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getGpioData(int gpioIdx) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().getGpioData(gpioIdx);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getPanelPower() {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().getPanelPower();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPanelPower(boolean value) {
        try {
            XbhAidlApi.getInstance().getDeviceInterface().setPanelPower(value);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getSupportEnable(int device) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().getSupportEnable(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setLcdTestMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().setLcdTestMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAdcData(int value) {
        try {
            return XbhAidlApi.getInstance().getDeviceInterface().getAdcData(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

