/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.wifi;

import android.os.RemoteException;
import com.hisense.hotel.HisenseManager;
import com.xbh.unf4.utils.WifiConfigUtil;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.bean.WifiConfig;

public class WifiHelper {
    private static final String TAG = "XBH-SDK-" + WifiHelper.class.getSimpleName();

    public boolean getWifiEnabled() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiEnabled();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setWifiEnabled(boolean enable) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().setWifiEnabled(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean isWifiConnected() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().isWifiConnected();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int getDisableReason(String ssid, int networkId) {
        int res = -1;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getDisableReason(ssid, networkId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean connectOpenNetwork(String ssid) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().connectOpenNetwork(ssid);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean connectNetwork(int networkId) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().connectNetwork(networkId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean connectNetworkByConfig(String wifiCfgStr) {
        WifiConfig wifiConfig = WifiConfigUtil.parseWifiConfig(wifiCfgStr);
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().connectNetworkByConfig(wifiConfig);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean disconnectWifi(int netId) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().disconnectWifi(netId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean removeNetwork(int netId) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().removeNetwork(netId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int getCapability(String capabilities) {
        int res = -1;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getCapability(capabilities);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String securityToString(String capabilities) {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().securityToString(capabilities);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiConfig(String ssid, int networkId) {
        String res = null;
        try {
            WifiConfig wifiConfig = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiConfig(ssid, networkId);
            res = WifiConfigUtil.toJsonWifiConfig(wifiConfig);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String loadCertificates(boolean isUser) {
        String res = null;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().loadCertificates(isUser);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiPasswd() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiPasswd();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setWifiDHCP() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().setWifiDHCP();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setWifiStatic(String ip, String mask, String gateway, String dns1, String dns2) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().setWifiStatic(ip, mask, gateway, dns1, dns2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiMode() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiMacAddr() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiMacAddr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiIPAddress() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiIPAddress();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiIPv6Address() {
        return HisenseManager.getInstance().getWifiIPv6Address();
    }

    public String getWifiMask() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiMask();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiGateWay() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiGateWay();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiDNS1() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiDNS1();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiDNS2() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiDNS2();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean isWifiApSupport() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().isWifiApSupport();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setWifiApEnable(boolean enable) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().setWifiApEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setCustomWifiApEnable(boolean enable) {
        boolean res = false;
        try {
            res = HisenseManager.getInstance().setCustomWifiApEnable(enable);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public boolean setWifiApEnableByConfig(String SSID, String password, int allowedKeyManagement, int apChannel) {
        boolean res = false;
        res = HisenseManager.getInstance().setWifiApEnableByConfig(SSID, password, allowedKeyManagement, apChannel);
        return res;
    }

    public boolean getWifiApEnable() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiApSSID() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApSSID();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiApPasswd() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApPasswd();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int getWifiApAllowedKeyManagement() {
        int res = -1;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApAllowedKeyManagement();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int getWifiApChannel() {
        int res = -1;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApChannel();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int getWifiApSupportChannel() {
        int res = -1;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApSupportChannel();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiApMacAddress() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApMacAddress();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setWifiApBlackList(String macAddress, boolean isBlack) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().setWifiApBlackList(macAddress, isBlack);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public int getAvailableNetworkType() {
        int res = -1;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getAvailableNetworkType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean setWifiApShareEnable(boolean enable) {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().setWifiApShareEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean getWifiApShareEnable() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApShareEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public boolean clearWifiApSharingEnable() {
        boolean res = false;
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().clearWifiApSharingEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getWifiApIpaddress() {
        String res = "";
        try {
            res = XbhAidlApi.getInstance().getWifiManagerInterface().getWifiApIpaddress();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return res;
    }
}

