/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.sourcemanager;

import android.os.RemoteException;
import android.util.Log;
import com.hisense.hotel.HisenseManager;
import java.util.List;
import java.util.stream.Collectors;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.ISourceManagerListener;

public class SourceManagerHelper {
    private static final String TAG = "XBH-SDK-" + SourceManagerHelper.class.getSimpleName();
    public static final String SETTING_DB_KEY_HDMI123_EDID_VERSION = "hdmi123_edid_version";

    public boolean registerSourceManagerListener(ISourceManagerListener listener) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().registerSourceManagerListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterSourceManagerListener(ISourceManagerListener listener) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().unRegisterSourceManagerListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCurSourceId() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getCurSourceId();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getCurPlatformSourceInputID(int userId) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getCurPlatformSourceInputID(userId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getPreviousSource() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getPreviousSource();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getPowerOnChangeSourceType() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getPowerOnChangeSourceType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPowerOnChangeSourceType(int id) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setPowerOnChangeSourceType(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAppointSourcePowerOn() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getAppointSourcePowerOn();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setAppointSourcePowerOn(int id) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setAppointSourcePowerOn(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCurSignalStatus() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getCurSignalStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean changeToSource(int srcIdx) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().changeToSource(srcIdx);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean changeToSourceInFreedomMode(int srcIdx, int left, int top, int width, int height, boolean isInsertMode) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().changeToSourceInFreedomMode(srcIdx, left, top, width, height, isInsertMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean changePreViewSource(int id, int x, int y, int w, int h, boolean isAudioMute, boolean isUsbFollow) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().changePreViewSource(id, x, y, w, h, isAudioMute, isUsbFollow);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean changeToSourceInMultiWindowMode(int srcIdx, int multiWindowModeSide) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().changeToSourceInMultiWindowMode(srcIdx, multiWindowModeSide);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getSourceName(int id) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getSourceName(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setCustomSourceName(int id, String name) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setCustomSourceName(id, name);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getCustomSourceName(int id) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getCustomSourceName(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setInputEnable(int id, boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setInputEnable(id, enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getInputEnable(int id) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getInputEnable(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Integer> getAvailSourceList() {
        try {
            List<String> strList = XbhAidlApi.getInstance().getSourceManagerInterface().getAvailSourceList();
            List<Integer> integerList = strList.stream().map(Integer::parseInt).collect(Collectors.toList());
            return integerList;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Integer> getAllSourceIdList() {
        try {
            List<String> strList = XbhAidlApi.getInstance().getSourceManagerInterface().getAllSourceIdList();
            List<Integer> integerList = strList.stream().map(Integer::parseInt).collect(Collectors.toList());
            return integerList;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setHdmiOutEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setHdmiOutEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getHdmiOutEnable() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getHdmiOutEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setHdmiOutTimmingFormat(int format) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setHdmiOutTimmingFormat(format);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getHdmiOutTimmingFormat() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getHdmiOutTimmingFormat();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setHdmiOutHdcpEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setHdmiOutHdcpEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getHdmiOutHdcpEnable() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getHdmiOutHdcpEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isHdmiOutConnected() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().isHdmiOutConnected();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean autoAdjust() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().autoAdjust();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setHPosition(int position) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setHPosition(position);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getHPosition() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getHPosition();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setVPosition(int position) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setVPosition(position);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getVPosition() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getVPosition();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setClock(int clock) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setClock(clock);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getClock() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getClock();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPhase(int phase) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setPhase(phase);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPhase() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getPhase();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setHdmirxEdidType(int version) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setHdmirxEdidType(version);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getHdmirxEdidType() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getHdmirxEdidType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setNoSignalStandbyEnable(boolean enable) {
        return HisenseManager.getInstance().setNoSignalStandbyEnable(enable);
    }

    public boolean getNoSignalStandbyEnable() {
        return HisenseManager.getInstance().getNoSignalStandbyEnable();
    }

    public boolean setNoSignalStandby(int value) {
        return HisenseManager.getInstance().setNoSignalStandby(value);
    }

    public int getNoSignalStandby() {
        return HisenseManager.getInstance().getNoSignalStandby();
    }

    public boolean getAutoSourceSwitch() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getAutoSourceSwitch();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setAutoSourceSwitch(boolean value, boolean confirm) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setAutoSourceSwitch(value, confirm);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setAutoSourceUiEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setAutoSourceUiEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getAutoSourceUiEnable() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getAutoSourceUiEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSourceHeight() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getSourceHeight();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSourceWidth() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getSourceWidth();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSourceFrameRate() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getSourceFrameRate();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean getCurrentSrcDet(int srcIdx) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getCurrentSrcDet(srcIdx);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCurrentSourceMute(boolean mute) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setCurrentSourceMute(mute);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getUsbFollowPort() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getUsbFollowPort();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setUsbFollowPort(int port) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setUsbFollowPort(port);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setArcEnable(boolean enable) {
        try {
            XbhAidlApi.getInstance().getSourceManagerInterface().setArcEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getArcEnable() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getArcEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setScheduleSource(int srcIdx) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setScheduleSource(srcIdx);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScheduleSource() {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().getScheduleSource();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 100;
        }
    }

    public boolean setHdmiEdidVersionBySource(int edidVersion, int srcId) {
        try {
            int hdmi1Edid = this.getHdmiEdidVersionBySource(15);
            int hdmi2Edid = this.getHdmiEdidVersionBySource(9);
            int hdmi3Edid = this.getHdmiEdidVersionBySource(10);
            if (srcId == 15) {
                hdmi1Edid = edidVersion;
            } else if (srcId == 9) {
                hdmi2Edid = edidVersion;
            } else if (srcId == 10) {
                hdmi3Edid = edidVersion;
            }
            String hdmiEdid = String.valueOf(hdmi1Edid) + String.valueOf(hdmi2Edid) + String.valueOf(hdmi3Edid);
            Log.d((String)TAG, (String)("setHdmiEdidVersionBySource: hdmiEdid=" + hdmiEdid));
            XbhAidlApi.getInstance().getDatabaseInterface().setSystemProperties("persist.sys.hdmiedid", hdmiEdid);
            XbhAidlApi.getInstance().getSystemInterface().setSettingsDatabase(1, 3, SETTING_DB_KEY_HDMI123_EDID_VERSION, hdmiEdid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getHdmiEdidVersionBySource(int srcId) {
        try {
            String value = XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties("persist.sys.hdmiedid", "000");
            String hdmi1Edid = value.substring(0, 1);
            String hdmi2Edid = value.substring(1, 2);
            String hdmi3Edid = value.substring(2, 3);
            Log.d((String)TAG, (String)("getHdmiEdidVersionBySource: value=" + value + ",hdmi1Edid=" + hdmi1Edid + ",hdmi2Edid=" + hdmi2Edid + ",hdmi3Edid=" + hdmi3Edid));
            if (srcId == 15) {
                return Integer.valueOf(hdmi1Edid);
            }
            if (srcId == 9) {
                return Integer.valueOf(hdmi2Edid);
            }
            if (srcId == 10) {
                return Integer.valueOf(hdmi3Edid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean getCurrentHdmiHdcpStatus(int curSrcId) {
        try {
            int inputId = -1;
            if (curSrcId == 15 || curSrcId == 17 || curSrcId == 19) {
                inputId = 0;
            } else if (curSrcId == 9 || curSrcId == 29) {
                inputId = 2;
            } else if (curSrcId == 10) {
                inputId = 1;
            }
            Log.d((String)TAG, (String)("getCurrentHdmiHdcpStatus: inputId=" + inputId + ",curSrcId=" + curSrcId));
            if (curSrcId == 21 || inputId == -1) {
                return false;
            }
            int status = XbhAidlApi.getInstance().getSourceManagerInterface().getHdmiHdcpStatus(inputId);
            int hdcp14EncryptionStatus = (status & 0xFF00) >> 8;
            int hdcp22EncryptionStatus = status & 0xFF;
            Log.d((String)TAG, (String)("getCurrentHdmiHdcpStatus: hdcp14EncryptionStatus=" + hdcp14EncryptionStatus + ",hdcp22EncryptionStatus=" + hdcp22EncryptionStatus + ",status=" + status + ",inputId=" + inputId));
            if (hdcp14EncryptionStatus == 2 || hdcp22EncryptionStatus == 2) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setSourceSwitchPort(int srcId) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setSourceSwitchPort(srcId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSourceUsbPort(int srcId) {
        try {
            return XbhAidlApi.getInstance().getSourceManagerInterface().setSourceUsbPort(srcId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setBootPlayListSourceEnable(boolean enable) {
        HisenseManager.getInstance().setBootPlayListSourceEnable(enable);
    }

    public boolean getBootPlayListSourceEnable() {
        return HisenseManager.getInstance().getBootPlayListSourceEnable();
    }

    public void setSourceBakEnable(boolean enable) {
        HisenseManager.getInstance().setSourceBakEnable(enable);
    }

    public boolean getSourceBakEnable() {
        return HisenseManager.getInstance().getSourceBakEnable();
    }

    public void setSourceBakMasterChannel(int channel) {
        HisenseManager.getInstance().setSourceBakMasterChannel(channel);
    }

    public int getSourceBakMasterChannel() {
        return HisenseManager.getInstance().getSourceBakMasterChannel();
    }

    public void setSourceBakSlaveChannel(int channel) {
        HisenseManager.getInstance().setSourceBakSlaveChannel(channel);
    }

    public int getSourceBakSlaveChannel() {
        return HisenseManager.getInstance().getSourceBakSlaveChannel();
    }

    public void setSourceBakChannelExtra(String extra) {
        HisenseManager.getInstance().setSourceBakChannelExtra(extra);
    }

    public String getSourceBakChannelExtra() {
        return HisenseManager.getInstance().getSourceBakChannelExtra();
    }
}

