/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.system;

import android.app.backup.BackupManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.text.TextUtils;
import com.hisense.hotel.HisenseManager;
import com.xbh.sdk4.utils.UtilsHelper;
import com.xbh.unf4.PlatformLogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.ISystemListener;

public class SystemHelper {
    private static final String TAG = "XBH-SDK-" + SystemHelper.class.getSimpleName();
    private static final String ENV_FIRST_SN = "first_SN";
    private static final int port = 1025;
    public static final String FACTORY_AGING_TIMER = "sys.xbh.factory.agingtime";
    public static final int TO_FAC_UI_M = 0;
    public static final int TO_FAC_UI_U = 1;
    public static final String SYSTEM_DB_KEY_TO_FAC_UI = "to_fac_ui";
    public static final int FACTORY_STATE = 0;
    public static final int USER_STATE = 1;
    public static final int BRIGHTNESS = 0;
    public static final int SOFTNESS = 1;
    public static final int STOP = 0;
    public static final int START = 1;
    public static final int OK = 1;
    public static final int FAIL = 0;
    public static final int DV650QUB_N20 = 0;
    public static final int TCON_TYPE_MAX = 1;

    public boolean registerSystemListener(ISystemListener listener) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().registerSystemListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterSystemListener(ISystemListener listener) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().unRegisterSystemListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String executeCommand(String command) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().executeCommand(command);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String executeCommandWithoutSystem(String command) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().executeCommandWithoutSystem(command);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getBurnInModeState() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getBurnInModeState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBurnInModeState(boolean value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setBurnInModeState(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateSystem(String path, boolean reboot, boolean showTips) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().updateSystem(path, reboot, showTips);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCustomOTAServerAddress(String addr) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setCustomOTAServerAddress(addr);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean powerOff() {
        try {
            if (this.getFakePowerOff() || this.getScreenBlankStatus() == 2) {
                if (this.getScreenBlankStatus() == 1) {
                    XbhAidlApi.getInstance().getSoundInterface().setHpMute(true);
                    return this.setScreenBlank(false, true, true);
                }
                XbhAidlApi.getInstance().getSoundInterface().setHpMute(false);
                return this.setScreenBlank(true, true, false);
            }
            return XbhAidlApi.getInstance().getSystemInterface().powerOff();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean powerOffByDelay(int delayInMS) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().powerOffByDelay(delayInMS);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setScreenBlank(boolean onOff, boolean lockScreen, boolean muteAudio) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setScreenBlank(onOff, lockScreen, muteAudio);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean reboot() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().reboot();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean rebootByDelay(int delayInMS) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().rebootByDelay(delayInMS);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPowerOnMode() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getPowerOnMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setPowerOnMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setPowerOnMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getStandbyMode() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getStandbyMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setStandbyMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setStandbyMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getPowerStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getPowerStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setBootLogo(String path) {
        boolean result = false;
        String tempPath = "/sdcard/logo.jpg";
        if (path.contains(".png") || path.contains(".PNG")) {
            UtilsHelper.pngToJpg(path, tempPath);
            path = "/sdcard/logo.jpg";
        }
        try {
            result = XbhAidlApi.getInstance().getSystemInterface().setBootLogo(path);
            if (path.contains(".png") || path.contains(".PNG")) {
                this.executeCommand("rm -f " + tempPath);
            }
            return result;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBootLogo(String path, boolean isSave) {
        return HisenseManager.getInstance().setBootLogo(path, isSave);
    }

    public String getBootLogo() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getBootLogo();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBootLogo(boolean isSave) {
        return HisenseManager.getInstance().getBootLogo(isSave);
    }

    public boolean setBootAnimation(String path) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setBootAnimation(path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBootAnimation(String path, boolean isSave) {
        return HisenseManager.getInstance().setBootAnimation(path, isSave);
    }

    public String getBootAnimation() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getBootAnimation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBootAnimation(boolean isSave) {
        return HisenseManager.getInstance().getBootAnimation(isSave);
    }

    public boolean setSntpServerEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setSntpServerEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getSntpServerEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSntpServerEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getMICEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getMICEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setMICEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setMICEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getPanelResolution() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getPanelResolution();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String screenShotWithDirectory(String directory) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().screenShotWithDirectory(directory);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bitmap screenShot() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().screenShot();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getWOLStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getWOLStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setWOLStatus(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setWOLStatus(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getDebugEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getDebugEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDebugEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setDebugEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setForbidInstallAppsStatus(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setForbidInstallAppsStatus(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getForbidInstallAppsStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getForbidInstallAppsStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public float getCPUUsage() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCPUUsage();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public float getMemoryUsage() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getMemoryUsage();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public float getFreeStorageCapacity() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getFreeStorageCapacity();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public float getEmmcSize() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getEmmcSize();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public boolean setAdbEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setAdbEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getAdbEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getAdbEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setWakeOnProximity(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setWakeOnProximity(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getWakeOnProximity() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getWakeOnProximity();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getDeviceTemperature() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getDeviceTemperature();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setEnvironmentTemperature(int temperature) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setEnvironmentTemperature(temperature);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getEnvironmentTemperature() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getEnvironmentTemperature();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setEnvironmentTemperatureWarnning(int temperature) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setEnvironmentTemperatureWarnning(temperature);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getEnvironmentTemperatureWarnning() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getEnvironmentTemperatureWarnning();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getCurrentBuildTime() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCurrentBuildTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCurrentBuildVersion() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCurrentBuildVersion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCurrentModelName() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCurrentModelName();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCurrentUserCode() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCurrentUserCode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getSleepTime() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSleepTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSleepTime(int time) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setSleepTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getShutdownEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getShutdownEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setShutdownEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setShutdownEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getShutdownTime() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getShutdownTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setShutdownTime(int time) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setShutdownTime(time);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean restoreUserSettings() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().restoreUserSettings();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean restoreSystemSettings() {
        try {
            boolean opsPowerOnState = XbhAidlApi.getInstance().getOpsProcessInterface().getOpsPowerOnState();
            if (opsPowerOnState) {
                XbhAidlApi.getInstance().getSystemUIInterface().showShutdownOpsDialog();
                return false;
            }
            return HisenseManager.getInstance().restoreSystemSettings();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSerialNum(String sn) {
        try {
            String firstSN = this.getEmmcEnv(ENV_FIRST_SN);
            if (TextUtils.isEmpty((CharSequence)firstSN)) {
                this.setEmmcEnv(ENV_FIRST_SN, sn);
            }
            return XbhAidlApi.getInstance().getSystemInterface().setSerialNum(sn);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getFristSerialNum() {
        try {
            return this.getEmmcEnv(ENV_FIRST_SN);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSerialNum() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSerialNum();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setHisenseSerialNum(String sn) {
        if (sn != null) {
            try {
                return HisenseManager.getInstance().setHisenseSerialNum(sn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getHisenseSerialNum() {
        try {
            return HisenseManager.getInstance().getHisenseSerialNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getFristHisenseSerialNum() {
        try {
            return HisenseManager.getInstance().getFristHisenseSerialNum();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getCustomPersistentData() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCustomPersistentData();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setCustomPersistentData(String data) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setCustomPersistentData(data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setNonThroughTouchRegion(int id, int x, int y, int w, int h) {
        try {
            boolean is4K = XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByBool("persist.sys.display.4k2k", false);
            return XbhAidlApi.getInstance().getSystemInterface().setNonThroughTouchRegion(id, is4K, x, y, w, h);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removeNonThroughTouchRegion(int id, int x, int y, int w, int h) {
        try {
            boolean is4K = XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByBool("persist.sys.display.4k2k", false);
            return XbhAidlApi.getInstance().getSystemInterface().removeNonThroughTouchRegion(id, is4K, x, y, w, h);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removeAllNonThroughTouchRegion() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().removeAllNonThroughTouchRegion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setChipRuntime(int value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setChipRuntime(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getChipRuntime() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getChipRuntime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSystemRuntime(int value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setSystemRuntime(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSystemRuntime() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSystemRuntime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean getFattEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getFattEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void processUSBMountChange(String action) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().processUSBMountChange(action);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean setEnvironment(String strName, String strVal) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setEnvironment(strName, strVal);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getEnvironment(String strName) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getEnvironment(strName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setBlackBoardTime(int value) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setBlackBoardTime(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getBlackBoardTime() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getBlackBoardTime();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean getRs232Enable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getRs232Enable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setRs232Enable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setRs232Enable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setAndoridScreenOffset(int offsetX, int offsetY) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setAndoridScreenOffset(offsetX, offsetY);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSourceScreenOffset(int offsetX, int offsetY) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setSourceScreenOffset(offsetX, offsetY);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getWOSStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getWOSStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setWOSStatus(boolean value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setWOSStatus(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setWOSSleep(boolean value) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setWOSSleep(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getWOSSleep() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getWOSSleep();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getFixedOTAServerList() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getFixedOTAServerList();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCustomOTAServerAddress() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCustomOTAServerAddress();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setUsbEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setUsbEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getUsbEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getUsbEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setTwoFingerGestureEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setTwoFingerGestureEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getTwoFingerGestureEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getTwoFingerGestureEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setChildLockEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setChildLockEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getChildLockEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getChildLockEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setChildLockParam(int flag) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setChildLockParam(flag);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getChildLockParam() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getChildLockParam();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setTouchInductionEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setTouchInductionEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getTouchInductionEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getTouchInductionEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setScreenCastActivationCode(int vendor, String activationCode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setScreenCastActivationCode(vendor, activationCode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getScreenCastActivationCode(int vendor) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getScreenCastActivationCode(vendor);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setScreenRecorderSoundMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setScreenRecorderSoundMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean startScreenRecorder(int width, int height, int frameRate, String savePath) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().startScreenRecorder(width, height, frameRate, savePath);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean pauseScreenRecorder(boolean state) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().pauseScreenRecorder(state);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean stopScreenRecorder() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().stopScreenRecorder();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDigitalMicList() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getDigitalMicList();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDefaultDigitalMic() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getDefaultDigitalMic();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setDefaultDigitalMic(String usbDevice) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setDefaultDigitalMic(usbDevice);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecEnable(boolean enable) {
        try {
            return HisenseManager.getInstance().setCecEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getCecEnable() {
        try {
            return HisenseManager.getInstance().getCecEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecAutoPowerOffEnable(boolean enable) {
        try {
            return HisenseManager.getInstance().setCecAutoPowerOffEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getCecAutoPowerOffEnable() {
        try {
            return HisenseManager.getInstance().getCecAutoPowerOffEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecAutoWakeUpEnable(boolean enable) {
        try {
            return HisenseManager.getInstance().setCecAutoWakeUpEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getCecAutoWakeUpEnable() {
        try {
            return HisenseManager.getInstance().getCecAutoWakeUpEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getCecIrControlEnable() {
        try {
            return HisenseManager.getInstance().getCecIrControlEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCecIrControlEnable(boolean enable) {
        try {
            return HisenseManager.getInstance().setCecIrControlEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setDefaultLauncher(String pkgName) {
        try {
            HisenseManager.getInstance().setDefaultLauncher(pkgName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDefaultLauncher() {
        try {
            return HisenseManager.getInstance().getDefaultLauncher();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setMonitorId(String monitorId) {
        try {
            return HisenseManager.getInstance().setMonitorId(monitorId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMonitorId() {
        try {
            return HisenseManager.getInstance().getMonitorId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setSettingsDatabase(int level, int dataType, String key, String value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setSettingsDatabase(level, dataType, key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getSettingsDatabase(int level, String key) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSettingsDatabase(level, key);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setPalmType(int type) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setPalmType(type);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getNotProcessTouchPackageNameWhitelist() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getNotProcessTouchPackageNameWhitelist();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getNotProcessTouchClassNameWhitelist() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getNotProcessTouchClassNameWhitelist();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getHumidity() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getHumidity();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getLightSensorValue() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getLightSensorValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getTemperatureSensorValue() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getTemperatureSensorValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSensorPM1P0Value() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorPM1P0Value();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSensorPM2P5Value() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorPM2P5Value();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSensorPM10Value() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorPM10Value();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSensorTVOCValue() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorTVOCValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getSensorCO2Value() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorCO2Value();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public float getSensorDistanceEValue() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorDistanceEValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public float getSensorDistance2EValue() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorDistance2EValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public float getSensorDistance3EValue() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSensorDistance3EValue();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1.0f;
        }
    }

    public int getAutoWakeUpSwStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getAutoWakeUpSwStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setAutoWakeUpSwStatus(int value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setAutoWakeUpSwStatus(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setAirIonizerEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setAirIonizerEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getAirIonizerEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getAirIonizerEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setAirIonizerMode(int airMode) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setAirIonizerMode(airMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAirIonizerMode() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getAirIonizerMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String getCodecVer(int verType) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCodecVer(verType);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getProjectIDVersion() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getProjectIDVersion();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getSourceTouchState() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getSourceTouchState(1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSourceTouchState(boolean onoff) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setSourceTouchState(1, onoff);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean mountUsb(String volumeId) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().mountUsb(volumeId);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getScreenBlankStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getScreenBlankStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setEmmcEnv(String key, String value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setEmmcEnv(key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getEmmcEnv(String key) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getEmmcEnv(key);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setWoRCtl(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setWoRCtl(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getWoRCtl() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getWoRCtl();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setProjectId(String id) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setProjectId(id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getProjectId() {
        try {
            String projectId = XbhAidlApi.getInstance().getSystemInterface().getProjectId();
            if (TextUtils.isEmpty((CharSequence)projectId) || projectId.equals("1")) {
                projectId = "43";
            }
            return projectId;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getHXAgingTimer() {
        try {
            return XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties(FACTORY_AGING_TIMER, "0");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void startShowInternalImage(int type) {
        try {
            HisenseManager.getInstance().startShowInternalImage(type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stoptShowInternalImage() {
        try {
            HisenseManager.getInstance().stoptShowInternalImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInternalImagepattern(int level) {
        try {
            HisenseManager.getInstance().setInternalImagepattern(level);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setToFacUiState(int state) {
        try {
            HisenseManager.getInstance().setToFacUiState(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getToFacUiState() {
        try {
            return HisenseManager.getInstance().getToFacUiState();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setFactoryState(int state) {
        try {
            HisenseManager.getInstance().setFactoryState(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFactoryState() {
        try {
            return HisenseManager.getInstance().getFactoryState();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setFactoryMac() {
        try {
            HisenseManager.getInstance().setFactoryMac();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFactoryHdcp22() {
        try {
            HisenseManager.getInstance().setFactoryHdcp22();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFactoryHdcp14() {
        try {
            HisenseManager.getInstance().setFactoryHdcp14();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFactoryCountry() {
        try {
            HisenseManager.getInstance().setFactoryCountry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFactoryCountryEnv(String country) {
        try {
            HisenseManager.getInstance().setFactoryCountryEnv(country);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFactoryCountry() {
        try {
            return HisenseManager.getInstance().getFactoryCountry();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setScreenCheck(int pattern) {
        try {
            HisenseManager.getInstance().setScreenCheck(pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearMotherBlock() {
        try {
            HisenseManager.getInstance().clearMotherBlock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startFactoryState() {
        try {
            HisenseManager.getInstance().startFactoryState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopFactoryState() {
        try {
            HisenseManager.getInstance().stopFactoryState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getEnergySavingMode() {
        try {
            return HisenseManager.getInstance().getEnergySavingMode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setEnergySavingMode(int mode) {
        try {
            HisenseManager.getInstance().setEnergySavingMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startAgingMode() {
        try {
            HisenseManager.getInstance().startAgingMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopAgingMode() {
        try {
            HisenseManager.getInstance().stopAgingMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getAgingModeState() {
        try {
            return HisenseManager.getInstance().getAgingModeState();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void showSnowPattern(boolean show) {
        HisenseManager.getInstance().showSnowPattern(show);
    }

    public int getUsageTime() {
        boolean usageTime = false;
        return HisenseManager.getInstance().getUsageTime();
    }

    public void setUsageTime(int time) {
        try {
            HisenseManager.getInstance().setUsageTime(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFactoryLanguage() {
        try {
            return HisenseManager.getInstance().getFactoryLanguage();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setFactoryLanguageEnv(String factoryLanguage) {
        try {
            HisenseManager.getInstance().setFactoryLanguageEnv(factoryLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFactoryLanguage() {
        try {
            HisenseManager.getInstance().setFactoryLanguage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFactoryResetState(int state) {
        HisenseManager.getInstance().setFactoryResetState(state);
    }

    public int getFactoryResetState() {
        return HisenseManager.getInstance().getFactoryResetState();
    }

    public void setTimeZone(String olsonId) {
        try {
            HisenseManager.getInstance().setTimeZone(olsonId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateSystemLanguage(Locale locale) {
        try {
            Class<?> clzIActMag = Class.forName("android.app.IActivityManager");
            Class<?> clzActMagNative = Class.forName("android.app.ActivityManagerNative");
            Method mtdActMagNative$getDefault = clzActMagNative.getDeclaredMethod("getDefault", new Class[0]);
            Object objIActMag = mtdActMagNative$getDefault.invoke(clzActMagNative, new Object[0]);
            Method mtdIActMag$getConfiguration = clzIActMag.getDeclaredMethod("getConfiguration", new Class[0]);
            Configuration config = (Configuration)mtdIActMag$getConfiguration.invoke(objIActMag, new Object[0]);
            config.setLocale(locale);
            Class<?> clzConfig = Class.forName("android.content.res.Configuration");
            Field userSetLocale = clzConfig.getField("userSetLocale");
            userSetLocale.set(config, true);
            Class[] clzParams = new Class[]{Configuration.class};
            Method mtdIActMag$updateConfiguration = clzIActMag.getDeclaredMethod("updatePersistentConfiguration", clzParams);
            mtdIActMag$updateConfiguration.invoke(objIActMag, config);
            BackupManager.dataChanged((String)"com.android.providers.settings");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTconType() {
        int type = 1;
        try {
            return HisenseManager.getInstance().getTconType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return type;
        }
    }

    public int[] getTconDevAddr(int type) {
        int[] devAddr = new int[3];
        try {
            return HisenseManager.getInstance().getTconDevAddr(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return devAddr;
        }
    }

    public int getVcomValue() {
        try {
            return XbhAidlApi.getInstance().getPicInterface().getVcomvalue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setVcomvalue(int vcomvalue) {
        boolean res = false;
        try {
            return XbhAidlApi.getInstance().getPicInterface().setVcomvalue(vcomvalue) == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public void showVcomView(boolean show) {
        try {
            HisenseManager.getInstance().showVcomView(show);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processF6saveVcom() {
        try {
            XbhAidlApi.getInstance().getPicInterface().VcomContorl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCustomModelName() {
        try {
            return this.getProjectId() + "DM66D";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getCustomFactoryVersion() {
        try {
            return this.getCustomModelName() + "." + this.getCurrentBuildVersion() + "." + this.getCurrentBuildTime().substring(0, 8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setPowerOnDelayEnable(boolean enable) {
        return HisenseManager.getInstance().setPowerOnDelayEnable(enable);
    }

    public boolean getPowerOnDelayEnable() {
        return HisenseManager.getInstance().getPowerOnDelayEnable();
    }

    public boolean setPowerOnDelay(int value) {
        return HisenseManager.getInstance().setPowerOnDelay(value);
    }

    public int getPowerOnDelay() {
        return HisenseManager.getInstance().getPowerOnDelay();
    }

    public void setFakePowerOff(boolean enable) {
        HisenseManager.getInstance().setFakePowerOff(enable);
    }

    public boolean getFakePowerOff() {
        return HisenseManager.getInstance().getFakePowerOff();
    }

    public void setLogEnable(boolean isLogEnable) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setLogEnable(isLogEnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getLogEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getLogEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setDreamStartTime(long value) {
        try {
            HisenseManager.getInstance().setDreamStartTime(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getDreamStartTime() {
        try {
            return HisenseManager.getInstance().getDreamStartTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public boolean getDreamControlEnable() {
        try {
            return HisenseManager.getInstance().getDreamControlEnable();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDreamControlEnable(boolean enable) {
        try {
            return HisenseManager.getInstance().setDreamControlEnable(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDreamPath() {
        try {
            return HisenseManager.getInstance().getDreamPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDreamPath(String path) {
        try {
            HisenseManager.getInstance().setDreamPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getDreamType() {
        try {
            return HisenseManager.getInstance().getDreamType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setDreamType(int value) {
        try {
            HisenseManager.getInstance().setDreamType(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNoSignalPicPath() {
        try {
            return HisenseManager.getInstance().getNoSignalPicPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean setNoSignalPicPath(String path) {
        try {
            return HisenseManager.getInstance().setNoSignalPicPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getNoSignalPicType() {
        try {
            return HisenseManager.getInstance().getNoSignalPicType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setNoSignalPicType(int value) {
        try {
            return HisenseManager.getInstance().setNoSignalPicType(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setFirstTempProtectFlag(boolean enable) {
        try {
            HisenseManager.getInstance().setFirstTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getFirstTempProtectFlag() {
        try {
            return HisenseManager.getInstance().getFirstTempProtectFlag();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSecondTempProtectFlag(boolean enable) {
        try {
            HisenseManager.getInstance().setSecondTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getSecondTempProtectFlag() {
        try {
            return HisenseManager.getInstance().getSecondTempProtectFlag();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setThirdTempProtectFlag(boolean enable) {
        try {
            HisenseManager.getInstance().setThirdTempProtectFlag(enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getThirdTempProtectFlag() {
        try {
            return HisenseManager.getInstance().getThirdTempProtectFlag();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void autoExportLog(String diskPath, boolean isAuto) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().autoExportLog(diskPath, isAuto);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getHDRType() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getHDRType();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setNoOpreationStandbyTime(int time) {
        try {
            return HisenseManager.getInstance().setNoOpreationStandbyTime(time);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getNoOpreationStandbyTime() {
        try {
            return HisenseManager.getInstance().getNoOpreationStandbyTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setWowStatus(boolean value) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setWowStatus(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getWowStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getWowStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCustomIRRemoteControllerLockStatus(int status) {
        try {
            PlatformLogUtil.d(TAG, "setCustomIRRemoteControllerLockStatus status=" + status);
            return XbhAidlApi.getInstance().getSystemInterface().setCustomIRRemoteControllerLockStatus(status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCustomIRRemoteControllerLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getCustomIRRemoteControllerLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setIRRemoteControllerLockStatus(boolean status) {
        try {
            PlatformLogUtil.d(TAG, "setIRRemoteControllerLockStatus =" + status);
            XbhAidlApi.getInstance().getSystemInterface().setIRRemoteControllerLockStatus(status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getIRRemoteControllerLockStatus() {
        try {
            PlatformLogUtil.d(TAG, "getIRRemoteControllerLockStatus =" + XbhAidlApi.getInstance().getSystemInterface().getIRRemoteControllerLockStatus());
            return XbhAidlApi.getInstance().getSystemInterface().getIRRemoteControllerLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setOnceIRRemoteControllerLockStatus(boolean onceStatus) {
        try {
            PlatformLogUtil.d(TAG, "setOnceIRRemoteControllerLockStatus =" + onceStatus);
            XbhAidlApi.getInstance().getSystemInterface().setOnceIRRemoteControllerLockStatus(onceStatus);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getOnceIRRemoteControllerLockStatus() {
        try {
            PlatformLogUtil.d(TAG, "getOnceIRRemoteControllerLockStatus =" + XbhAidlApi.getInstance().getSystemInterface().getOnceIRRemoteControllerLockStatus());
            return XbhAidlApi.getInstance().getSystemInterface().getOnceIRRemoteControllerLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setKeyPadControllerLockStatus(boolean status) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setKeyPadControllerLockStatus(status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getKeyPadControllerLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getKeyPadControllerLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setOnceKeyPadControllerLockStatus(boolean onceStatus) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setOnceKeyPadControllerLockStatus(onceStatus);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getOnceKeyPadControllerLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getOnceKeyPadControllerLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setMenuLockStatus(boolean status) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setMenuLockStatus(status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getMenuLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getMenuLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getOnceMenuLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getOnceMenuLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setOnceMenuLockStatus(boolean onceStatus) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setOnceMenuLockStatus(onceStatus);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setMultiScreenLockStatus(boolean status) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setMultiScreenLockStatus(status);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getMultiScreenLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getMultiScreenLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setOnceMultiScreenLockStatus(boolean onceStatus) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setOnceMultiScreenLockStatus(onceStatus);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getOnceMultiScreenLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getOnceMultiScreenLockStatus();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setOnceUsbEnable(boolean onceEnable) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setOnceUsbEnable(onceEnable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getOnceUsbEnable() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getOnceUsbEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setPermissionLockPassword(String passWord) {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().setPermissionLockPassword(passWord);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getPermissionLockPassword() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getPermissionLockPassword();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "0000";
        }
    }

    public boolean setTimedSwitch(boolean isPowerOff, boolean state, int hour, int minute, int type) {
        try {
            return HisenseManager.getInstance().setTimedSwitch(isPowerOff, state, -1, -1, -1, hour, minute, type, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setTimedSwitch(boolean isPowerOff, boolean state, int hour, int minute, int type, long timeStamp) {
        try {
            return HisenseManager.getInstance().setTimedSwitch(isPowerOff, state, -1, -1, -1, hour, minute, type, timeStamp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setCA(String path) {
        return HisenseManager.getInstance().setCA(path);
    }

    public String getCA() {
        return HisenseManager.getInstance().getCA();
    }

    public void getInstalledPermissionSummary(String pkg) {
        HisenseManager.getInstance().getInstalledPermissionSummary(pkg);
    }

    public boolean getAndroidChannelLockStatus() {
        try {
            return XbhAidlApi.getInstance().getSystemInterface().getAndroidChannelLockStatus() == 1;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setAndroidChannelLockStatus(boolean channelLockEnable) {
        try {
            XbhAidlApi.getInstance().getSystemInterface().setAndroidChannelLockStatus(channelLockEnable ? 1 : 0);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

