/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.sound;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.RemoteException;
import com.hisense.hotel.HisenseManager;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.listener.ISoundListener;

public class SoundHelper {
    private static final String TAG = "XBH-SDK-" + SoundHelper.class.getSimpleName();
    public static final int MTKsoundPCM = 0;
    public static final int MTKsoundRAW = 1;
    public static final int MTKsoundAuto = 2;
    public static final int HisensePCM = 1;
    public static final int HisenseRAW = 2;
    public static final int HisenseAuto = 0;
    public static final int MTKSoundModeMusic = 6;
    public static final int MTKSoundModeVivid = 1;
    public static final int MTKSoundModeMovie = 2;
    public static final int MTKSoundModeStandard = 3;
    public static final int HisenseSoundModeMusic = 2;
    public static final int HisenseSoundModeMovie = 1;
    public static final int HisenseSoundModeMetting = 3;
    public static final int HisenseSoundModeStandard = 0;
    public static final int AUDIO_SPEAKER_CHANNEL = 0;
    public static final int AUDIO_ARC_CHANNEL = 1;
    public static final int AUDIO_USB_CHANNEL = 2;
    public static final String AUDIO_CHANNEL = "custom_audio_channel";

    public boolean registerSoundListener(ISoundListener listener) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().registerSoundListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterSoundListener(ISoundListener listener) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().unRegisterSoundListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBass(int value) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setBass(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBass() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getBass();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setTreble(int value) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setTreble(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getTreble() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getTreble();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setBalance(int value) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setBalance(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBalance() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getBalance();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSoundMode(int value) {
        try {
            switch (value) {
                case 0: {
                    value = 3;
                    break;
                }
                case 1: {
                    value = 2;
                    break;
                }
                case 2: {
                    value = 6;
                    break;
                }
                case 3: {
                    value = 1;
                    break;
                }
            }
            return XbhAidlApi.getInstance().getSoundInterface().setSoundMode(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSoundMode() {
        try {
            int value = XbhAidlApi.getInstance().getSoundInterface().getSoundMode();
            switch (value) {
                case 6: {
                    value = 2;
                    break;
                }
                case 1: {
                    value = 3;
                    break;
                }
                case 2: {
                    value = 1;
                    break;
                }
                case 3: {
                    value = 0;
                    break;
                }
            }
            return value;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setVolume(int value, boolean showui) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setVolume(value, showui);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getVolume() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getVolume();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setMuteEnable(boolean value, boolean showui) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setMuteEnable(value, showui);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getMuteEnable() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getMuteEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEQ(int band, int gain) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setEQ(band, gain);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getEQ(int band) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getEQ(band);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setLineOutMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setLineOutMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLineOutMode() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getLineOutMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setAudioOutputState(int mode) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setAudioOutputState(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getAudioOutputState() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getAudioOutputState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setMuteMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setMuteMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getMuteMode() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getMuteMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setAvcEnable(boolean isAvcEnable) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setAvcEnable(isAvcEnable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getAvcEnable() {
        try {
            String frist = XbhAidlApi.getInstance().getDatabaseInterface().getSystemProperties("persist.xbh.avc_enable_frist", "false");
            if (frist.equals("false")) {
                this.setAvcEnable(false);
                XbhAidlApi.getInstance().getDatabaseInterface().setSystemProperties("persist.xbh.avc_enable_frist", "true");
                return XbhAidlApi.getInstance().getSoundInterface().getAvcEnable();
            }
            return XbhAidlApi.getInstance().getSoundInterface().getAvcEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSpdifOutMode(int spdifMode) {
        try {
            switch (spdifMode) {
                case 0: {
                    spdifMode = 2;
                    break;
                }
                case 1: {
                    spdifMode = 0;
                    break;
                }
                case 2: {
                    spdifMode = 1;
                    break;
                }
            }
            return XbhAidlApi.getInstance().getSoundInterface().setSpdifOutMode(spdifMode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSpdifOutMode() {
        try {
            int spdifMode = XbhAidlApi.getInstance().getSoundInterface().getSpdifOutMode();
            switch (spdifMode) {
                case 0: {
                    spdifMode = 1;
                    break;
                }
                case 1: {
                    spdifMode = 2;
                    break;
                }
                case 2: {
                    spdifMode = 0;
                    break;
                }
            }
            return spdifMode;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getEarPhoneVolume() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getEarPhoneVolume();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setEarPhoneVolume(int volume) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setEarPhoneVolume(volume);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean resetSoundSettings() {
        try {
            boolean res = XbhAidlApi.getInstance().getSoundInterface().resetSoundSettings();
            return res;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean resetCustomSoundSettings() {
        try {
            return HisenseManager.getInstance().resetCustomSoundSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setMicMute(boolean value) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setMicMute(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getMicMute() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getMicMute();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSoundAMPMode(int mode) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setSoundAMPMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getSoundAMPMode() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getSoundAMPMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setSubwooferMute(boolean isEnable) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setSubwooferMute(isEnable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getSubwooferMute() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getSubwooferMute();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSurroundEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setSurroundEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getSurroundEnable() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getSurroundEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getCurrentVolumeMax() {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getCurrentVolumeMax();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean setCurrentVolumeMax(int volume) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setCurrentVolumeMax(volume);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setVolumeUp() {
        int currentValue;
        if (this.getMuteEnable()) {
            this.setMuteEnable(false, false);
            for (int waitCnt = 0; this.getMuteEnable() && waitCnt < 10; ++waitCnt) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((currentValue = this.getVolume()) <= 100) {
            return this.setVolume(++currentValue, true);
        }
        return false;
    }

    public boolean setVolumeDown() {
        int currentValue = this.getVolume();
        if (currentValue > 0) {
            return this.setVolume(--currentValue, true);
        }
        return false;
    }

    public int getdefaultBalance() {
        try {
            return HisenseManager.getInstance().getdefaultBalance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public int getCurrentVolumeMin() {
        try {
            return HisenseManager.getInstance().getCurrentVolumeMin();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean setCurrentVolumeMin(int value) {
        try {
            return HisenseManager.getInstance().setCurrentVolumeMin(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public AudioDeviceInfo[] getAllAudioOutputDevices(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.getDevices(2);
    }

    public void setAudioDevices(int type) {
    }

    public int getDefaulteqvalue() {
        try {
            return HisenseManager.getInstance().getDefaulteqvalue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 50;
        }
    }

    public void setAudioChannel(int type) {
        HisenseManager.getInstance().setAudioChannel(type);
    }

    public int getAudioChannel() {
        return HisenseManager.getInstance().getAudioChannel();
    }

    public boolean setChannelMute(int channel, boolean value) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().setChannelMute(channel, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getChannelMute(int channel) {
        try {
            return XbhAidlApi.getInstance().getSoundInterface().getChannelMute(channel);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }
}

