/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.ethernet;

import android.os.RemoteException;
import android.text.TextUtils;
import com.hisense.hotel.HisenseManager;
import java.util.ArrayList;
import java.util.List;
import xbh.platform.aidl.XbhAidlApi;
import xbh.platform.aidl.bean.EthernetInfo;
import xbh.platform.aidl.listener.IEthernetListener;

public class EthernetHelper {
    private static final String TAG = "XBH-SDK-" + EthernetHelper.class.getSimpleName();

    public boolean registerEthernetListener(IEthernetListener listener) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().registerEthernetListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean unRegisterEthernetListener(IEthernetListener listener) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().unRegisterEthernetListener(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEthernetEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().setEthernetEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getEthernetEnable() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEthernetDHCP() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().setEthernetDHCP();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEthernetStatic(String ip, String mask, String gateway, String dns1) {
        try {
            String defaultDNS2 = XbhAidlApi.getInstance().getDatabaseInterface().getDataFromProviderByString("DEFAULT_DNS2", "114.114.114.114");
            return XbhAidlApi.getInstance().getEthernetInterface().setEthernetStatic(ip, mask, gateway, dns1, defaultDNS2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getEthernetInfo() {
        ArrayList<String> info = new ArrayList<String>();
        try {
            EthernetInfo ethernetInfo = XbhAidlApi.getInstance().getEthernetInterface().getEthernetInfo();
            info.add(ethernetInfo.getIpAddress());
            info.add(ethernetInfo.getNetMask());
            info.add(ethernetInfo.getGateway());
            info.add(ethernetInfo.getDns1());
            info.add(ethernetInfo.getDns2());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return info;
    }

    public String getEthernetMode() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetMode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getEthernetMacAddr() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetMacAddr();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getEthernetIPAddress() {
        try {
            String ethernetIPAddress = XbhAidlApi.getInstance().getEthernetInterface().getEthernetIPAddress();
            if (TextUtils.isEmpty((CharSequence)ethernetIPAddress)) {
                ethernetIPAddress = "0.0.0.0";
            }
            return ethernetIPAddress;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getEthernetIPv6Address() {
        String ipv6Address = HisenseManager.getInstance().getEthernetIPv6Address();
        if (TextUtils.isEmpty((CharSequence)ipv6Address)) {
            ipv6Address = "0000::0000::0000:0000:0000";
        }
        return ipv6Address;
    }

    public String getEthernetMask() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetMask();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getEthernetGateWay() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetGateWay();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getEthernetDNS1() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetDNS1();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getEthernetDNS2() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetDNS2();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setOpsNetState(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().setOpsNetState(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getOpsNetState() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getOpsNetState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDialUp(String name, String passwd) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().setDialUp(name, passwd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDialUpUserName() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getDialUpUserName();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getDialUpUserPwd() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getDialUpUserPwd();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setGlobalProxy(String ip, int port, List<String> address) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().setGlobalProxy(ip, port, address);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean closeGlobalProxy() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().closeGlobalProxy();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getEthernetPlugState() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getEthernetPlugState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setNetworkSharingEnable(boolean enable) {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().setNetworkSharingEnable(enable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean getNetworkSharingEnable() {
        try {
            return XbhAidlApi.getInstance().getEthernetInterface().getNetworkSharingEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }
}

