/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.middleware.sdkprovider.multiuser;

import android.text.TextUtils;
import com.xbh.middleware.sdkprovider.multiuser.XbhRestrictions;
import java.util.Arrays;
import java.util.Objects;

public class XbhRestrictionConfig {
    private final String description;
    private final String restriction;
    private final String[] scopes;

    public XbhRestrictionConfig(String restriction, String ... scopes) {
        this.description = XbhRestrictions.getRestrictionDesc(restriction);
        this.restriction = restriction;
        this.scopes = scopes;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public boolean isRestricted(String userType) {
        if (this.scopes != null && this.scopes.length > 0) {
            for (String scope : this.scopes) {
                if (!TextUtils.equals((CharSequence)scope, (CharSequence)userType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XbhRestrictionConfig)) {
            return false;
        }
        XbhRestrictionConfig that = (XbhRestrictionConfig)o;
        return Objects.equals(this.restriction, that.restriction);
    }

    public int hashCode() {
        int result = Objects.hash(this.description, this.getRestriction());
        result = 31 * result + Arrays.hashCode(this.scopes);
        return result;
    }

    public String toString() {
        return "XbhRestrictionConfig{description='" + this.description + '\'' + ", restriction='" + this.restriction + '\'' + ", scopes=" + Arrays.toString(this.scopes) + '}';
    }
}

