/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class UtilsHelper {
    public static String getSystemProperties(String key, String defaultValue) {
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getMethod("get", String.class, String.class);
            String value = (String)method.invoke(classtype, key, defaultValue);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setSystemProperties(String key, String value) {
        try {
            Class<?> classtype = Class.forName("android.os.SystemProperties");
            Method method = classtype.getMethod("set", String.class, String.class);
            method.invoke(classtype, key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pngToJpg(String pngFilePath, String jpgFilePath) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)pngFilePath);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(jpgFilePath));){
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos)) {
                bos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isUsbAudioDevice(UsbDevice usbDevice) {
        boolean isAudio = false;
        int intefaceCount = usbDevice.getInterfaceCount();
        for (int ninterIndex = 0; !isAudio && ninterIndex < intefaceCount; ++ninterIndex) {
            UsbInterface ntrface = usbDevice.getInterface(ninterIndex);
            if (ntrface.getInterfaceClass() != 1) continue;
            isAudio = true;
        }
        return isAudio;
    }
}

