/*
 * Decompiled with CFR 0.152.
 */
package com.xbh.sdk4.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.xbh.sdk4.bluetooth.IBluetoothInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import xbh.platform.aidl.XbhAidlApi;

public class BluetoothHelper {
    private static final String TAG = "XBH-SDK-" + BluetoothHelper.class.getSimpleName();
    private final BluetoothAdapter mBluetoothAdapter;
    private IBluetoothInterface.OnStateChangeCallBack mStateChangeCallBack;
    private IBluetoothInterface.OnPairBluetoothCallBack mPairCallBack;
    private IBluetoothInterface.OnScanBluetoothCallBack mScanCallBack;
    private final List<IBluetoothInterface.OnConnectBluetoothCallBack> mConnectCallBacks = new ArrayList<IBluetoothInterface.OnConnectBluetoothCallBack>();
    private static final int MSG_DISCOVERY = 100;
    private static final int MSG_CONNECT_TIMEOUT = 101;
    private static final int MSG_CONNECT_SUCCESS = 102;
    private static final int MSG_PARIED_SUCCESS = 103;
    private static final int MSG_REFRESH_CONNECT_STATUS = 104;
    private static final int CONNECT_TIME_OUT = 15000;
    private int mTempCount = 0;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 100) {
                BluetoothHelper.this.startDiscovery();
            } else if (msg.what == 101) {
                Log.e((String)TAG, (String)"mHandler: bluetooth connect timeout!");
                BluetoothHelper.this.mTempCount = 0;
                this.removeMessages(104);
                BluetoothDevice device = (BluetoothDevice)msg.obj;
                BluetoothHelper.this.connectFailed(device, "timeout");
            } else if (msg.what == 102) {
                Log.e((String)TAG, (String)"mHandler: bluetooth connect success .");
                BluetoothDevice device = (BluetoothDevice)msg.obj;
                BluetoothHelper.this.connectSuccess(device);
            } else if (msg.what == 103) {
                BluetoothDevice device = (BluetoothDevice)msg.obj;
                if (BluetoothHelper.this.mPairCallBack != null) {
                    BluetoothHelper.this.mPairCallBack.onBondSuccess(device);
                }
            } else if (msg.what == 104) {
                BluetoothDevice device = (BluetoothDevice)msg.obj;
                boolean isSuccess = BluetoothHelper.this.isConnect(device);
                Log.d((String)TAG, (String)("MSG_REFRESH_CONNECT_STATUS isConnect  = " + isSuccess));
                if (isSuccess) {
                    BluetoothHelper.this.connectSuccess(device);
                    BluetoothHelper.this.mTempCount = 0;
                    this.removeMessages(104);
                } else {
                    BluetoothHelper.this.mTempCount = BluetoothHelper.this.mTempCount + 1;
                    if (BluetoothHelper.this.mTempCount > 20) {
                        BluetoothHelper.this.mTempCount = 0;
                        BluetoothHelper.this.connectFailed(device, "timeout");
                        return;
                    }
                    Message message = new Message();
                    message.what = 104;
                    message.obj = device;
                    this.sendMessageDelayed(message, 1000L);
                }
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            Log.e((String)TAG, (String)("bluetooth receive ACTION = " + action + " , device = " + device));
            if (action == null) {
                return;
            }
            block11 : switch (action) {
                case "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED": {
                    if (BluetoothHelper.this.mStateChangeCallBack == null) break;
                    BluetoothHelper.this.mStateChangeCallBack.onNameChange();
                    break;
                }
                case "android.bluetooth.adapter.action.STATE_CHANGED": {
                    int state = BluetoothHelper.this.mBluetoothAdapter.getState();
                    Log.e((String)TAG, (String)("bluetooth receive state change " + state));
                    switch (state) {
                        case 12: {
                            BluetoothHelper.this.setScanMode(23);
                            if (BluetoothHelper.this.mStateChangeCallBack == null) break block11;
                            BluetoothHelper.this.mStateChangeCallBack.onOpened();
                            break block11;
                        }
                        case 11: {
                            if (BluetoothHelper.this.mStateChangeCallBack == null) break block11;
                            BluetoothHelper.this.mStateChangeCallBack.onOpening();
                            break block11;
                        }
                        case 10: {
                            BluetoothHelper.this.setScanMode(21);
                            if (BluetoothHelper.this.mStateChangeCallBack == null) break block11;
                            BluetoothHelper.this.mStateChangeCallBack.onCloseed();
                            break block11;
                        }
                        case 13: {
                            if (BluetoothHelper.this.mStateChangeCallBack == null) break block11;
                            BluetoothHelper.this.mStateChangeCallBack.onClosing();
                            break block11;
                        }
                    }
                    break;
                }
                case "android.bluetooth.adapter.action.DISCOVERY_STARTED": {
                    if (BluetoothHelper.this.mScanCallBack != null) {
                        BluetoothHelper.this.mScanCallBack.onScanStarted();
                    }
                    Log.e((String)TAG, (String)"bluetooth receive discovery started");
                    break;
                }
                case "android.bluetooth.adapter.action.DISCOVERY_FINISHED": {
                    if (BluetoothHelper.this.mScanCallBack != null) {
                        BluetoothHelper.this.mScanCallBack.onScanFinished();
                    }
                    Log.e((String)TAG, (String)"bluetooth receive discovery finished");
                    break;
                }
                case "android.bluetooth.device.action.FOUND": {
                    short rssi = intent.getExtras().getShort("android.bluetooth.device.extra.RSSI");
                    if (BluetoothHelper.this.mScanCallBack != null) {
                        BluetoothHelper.this.mScanCallBack.onScanning(device, rssi);
                    }
                    Log.e((String)TAG, (String)("bluetooth receive  found RSSI = " + rssi));
                    break;
                }
                case "android.bluetooth.device.action.PAIRING_REQUEST": {
                    if (device == null) {
                        throw new NullPointerException("bluetooth device is null.");
                    }
                    if (BluetoothHelper.this.mPairCallBack == null) break;
                    BluetoothHelper.this.mPairCallBack.onBondRequest();
                    break;
                }
                case "android.bluetooth.device.action.BOND_STATE_CHANGED": {
                    switch (device.getBondState()) {
                        case 10: {
                            if (BluetoothHelper.this.mPairCallBack != null) {
                                BluetoothHelper.this.mPairCallBack.onBondFail(device);
                            }
                            Log.e((String)TAG, (String)"bluetooth bond failed");
                            break block11;
                        }
                        case 11: {
                            if (BluetoothHelper.this.mPairCallBack != null) {
                                BluetoothHelper.this.mPairCallBack.onBonding(device);
                            }
                            Log.e((String)TAG, (String)"bluetooth bonding...");
                            break block11;
                        }
                        case 12: {
                            Message message = new Message();
                            message.what = 103;
                            message.obj = device;
                            BluetoothHelper.this.mHandler.sendMessageDelayed(message, 1000L);
                            Log.e((String)TAG, (String)"bluetooth bonded");
                            BluetoothHelper.this.connect(device);
                            break block11;
                        }
                    }
                    break;
                }
                case "android.bluetooth.device.action.ACL_CONNECTED": {
                    int major;
                    boolean isHeadSetConnected = BluetoothHelper.this.isHeadSetConnected(device);
                    Log.e((String)TAG, (String)("bluetooth \u8fde\u63a5\u6210\u529f\u5e7f\u64ad\u901a\u77e5 " + isHeadSetConnected + " , name = " + device.getName()));
                    BluetoothClass bluetoothClass = device.getBluetoothClass();
                    if (!(bluetoothClass == null || (major = bluetoothClass.getMajorDeviceClass()) != 256 && major != 512 || isHeadSetConnected)) {
                        BluetoothHelper.this.disconnect(device);
                        return;
                    }
                    BluetoothHelper.this.mHandler.removeMessages(102);
                    Message message = new Message();
                    message.what = 102;
                    message.obj = device;
                    BluetoothHelper.this.mHandler.sendMessageDelayed(message, 2000L);
                    break;
                }
                case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                    BluetoothHelper.this.connectFailed(device, "failed");
                    Log.e((String)TAG, (String)"bluetooth acl disconnected");
                    break;
                }
            }
        }
    };

    public BluetoothHelper() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public void registBluetoothReceiver(Context context) {
        this.openProfileProxy();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        filter.addAction("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
        filter.addAction("android.bluetooth.device.action.PAIRING_REQUEST");
        filter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        context.registerReceiver(this.mReceiver, filter);
    }

    public void unregistBluetoothReceiver(Context context) {
        this.closeProfileProxy();
        if (this.mReceiver != null) {
            context.unregisterReceiver(this.mReceiver);
        }
    }

    public void setOnStateChangeCallBack(IBluetoothInterface.OnStateChangeCallBack callBack) {
        this.mStateChangeCallBack = callBack;
    }

    public void setOnScanBluetoothCallBack(IBluetoothInterface.OnScanBluetoothCallBack callBack) {
        this.mScanCallBack = callBack;
    }

    public void setOnPairBluetoothCallBack(IBluetoothInterface.OnPairBluetoothCallBack callBack) {
        this.mPairCallBack = callBack;
    }

    public void addOnConnectBluetoothCallBack(IBluetoothInterface.OnConnectBluetoothCallBack callBack) {
        if (callBack == null) {
            return;
        }
        this.mConnectCallBacks.add(callBack);
    }

    public void removeOnConnectBluetoothCallBack(IBluetoothInterface.OnConnectBluetoothCallBack callBack) {
        if (callBack == null) {
            throw new NullPointerException("callback is null.");
        }
        this.mConnectCallBacks.remove(callBack);
        this.mHandler.removeMessages(104);
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.mBluetoothAdapter;
    }

    public void openProfileProxy() {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().openProfileProxy();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void closeProfileProxy() {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().closeProfileProxy();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isSupportBluetooth() {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isSupportBluetooth();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getBluetoothName() {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().getBluetoothName();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isEnable() {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isEnable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setEnable(boolean isEnable) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().setEnable(isEnable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setScanMode(int mode) {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().setScanMode(mode);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void startPair(BluetoothDevice device) {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().startPair(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void cancelPair(BluetoothDevice device) {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().cancelPair(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void connect(BluetoothDevice device) {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().connect(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void connectA2DP(BluetoothDevice device) {
        try {
            XbhAidlApi.getInstance().getBluetoothInterface().connectA2DP(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean isA2DPConnected(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isA2DPConnected(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isHeadSetConnected(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isHeadSetConnected(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isHealthConnected(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isHealthConnected(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isInputDeviceConnected(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isInputDeviceConnected(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean disconnectA2DP(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().disconnectA2DP(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean disconnect(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().disconnect(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isConnect(BluetoothDevice device) {
        try {
            return XbhAidlApi.getInstance().getBluetoothInterface().isConnect(device);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean startDiscovery() {
        if (!this.isSupportBluetooth()) {
            return false;
        }
        if (this.getBluetoothAdapter().isDiscovering()) {
            this.getBluetoothAdapter().cancelDiscovery();
        }
        return this.getBluetoothAdapter().startDiscovery();
    }

    public boolean cancelDiscovery() {
        return !this.isSupportBluetooth() || !this.getBluetoothAdapter().isDiscovering() || this.getBluetoothAdapter().cancelDiscovery();
    }

    public List<BluetoothDevice> getBondedDevices() {
        if (!this.isSupportBluetooth()) {
            return null;
        }
        Set pairedDevices = this.mBluetoothAdapter.getBondedDevices();
        return new ArrayList<BluetoothDevice>(pairedDevices);
    }

    private void connectSuccess(BluetoothDevice device) {
        if (this.mConnectCallBacks != null && this.mConnectCallBacks.size() > 0) {
            for (int i = 0; i < this.mConnectCallBacks.size(); ++i) {
                this.mConnectCallBacks.get(i).onConnectSuccess(device);
            }
        }
        this.removeConnectTimeOutMessage();
    }

    private void connectFailed(BluetoothDevice device, String reason) {
        for (int i = 0; i < this.mConnectCallBacks.size(); ++i) {
            this.mConnectCallBacks.get(i).onConnectFail(device, reason);
        }
        this.removeConnectTimeOutMessage();
    }

    private void removeConnectTimeOutMessage() {
        this.mHandler.removeMessages(101);
    }
}

